<?php
/**
 * The template to display Admin notices
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0.64
 */

$stomatology_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$stomatology_skins_args = get_query_var( 'stomatology_skins_notice_args' );
?>
<div class="stomatology_admin_notice stomatology_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$stomatology_theme_img = stomatology_get_file_url( 'screenshot.jpg' );
	if ( '' != $stomatology_theme_img ) {
		?>
		<div class="stomatology_notice_image"><img src="<?php echo esc_url( $stomatology_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'stomatology' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="stomatology_notice_title">
		<?php esc_html_e( 'New skins are available', 'stomatology' ); ?>
	</h3>
	<?php

	// Description
	$stomatology_total      = $stomatology_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$stomatology_skins_msg  = $stomatology_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $stomatology_total, 'stomatology' ), $stomatology_total ) . '</strong>'
							: '';
	$stomatology_total      = $stomatology_skins_args['free'];
	$stomatology_skins_msg .= $stomatology_total > 0
							? ( ! empty( $stomatology_skins_msg ) ? ' ' . esc_html__( 'and', 'stomatology' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $stomatology_total, 'stomatology' ), $stomatology_total ) . '</strong>'
							: '';
	$stomatology_total      = $stomatology_skins_args['pay'];
	$stomatology_skins_msg .= $stomatology_skins_args['pay'] > 0
							? ( ! empty( $stomatology_skins_msg ) ? ' ' . esc_html__( 'and', 'stomatology' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $stomatology_total, 'stomatology' ), $stomatology_total ) . '</strong>'
							: '';
	?>
	<div class="stomatology_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'stomatology' ), $stomatology_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="stomatology_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $stomatology_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'stomatology' );
			?>
		</a>
	</div>
</div>
