<?php
/**
 * The template to display the widgets area in the header
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */

// Header sidebar
$stomatology_header_name    = stomatology_get_theme_option( 'header_widgets' );
$stomatology_header_present = ! stomatology_is_off( $stomatology_header_name ) && is_active_sidebar( $stomatology_header_name );
if ( $stomatology_header_present ) {
	stomatology_storage_set( 'current_sidebar', 'header' );
	$stomatology_header_wide = stomatology_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $stomatology_header_name ) ) {
		dynamic_sidebar( $stomatology_header_name );
	}
	$stomatology_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $stomatology_widgets_output ) ) {
		$stomatology_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $stomatology_widgets_output );
		$stomatology_need_columns   = strpos( $stomatology_widgets_output, 'columns_wrap' ) === false;
		if ( $stomatology_need_columns ) {
			$stomatology_columns = max( 0, (int) stomatology_get_theme_option( 'header_columns' ) );
			if ( 0 == $stomatology_columns ) {
				$stomatology_columns = min( 6, max( 1, stomatology_tags_count( $stomatology_widgets_output, 'aside' ) ) );
			}
			if ( $stomatology_columns > 1 ) {
				$stomatology_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $stomatology_columns ) . ' widget', $stomatology_widgets_output );
			} else {
				$stomatology_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $stomatology_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'stomatology_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $stomatology_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $stomatology_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'stomatology_action_before_sidebar', 'header' );
				stomatology_show_layout( $stomatology_widgets_output );
				do_action( 'stomatology_action_after_sidebar', 'header' );
				if ( $stomatology_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $stomatology_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'stomatology_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
