<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */

// Page (category, tag, archive, author) title

if ( stomatology_need_page_title() ) {
	stomatology_sc_layouts_showed( 'title', true );
	stomatology_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								stomatology_show_post_meta(
									apply_filters(
										'stomatology_filter_post_meta_args', array(
											'components' => join( ',', stomatology_array_get_keys_by_value( stomatology_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', stomatology_array_get_keys_by_value( stomatology_get_theme_option( 'counters' ) ) ),
											'seo'        => stomatology_is_on( stomatology_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$stomatology_blog_title           = stomatology_get_blog_title();
							$stomatology_blog_title_text      = '';
							$stomatology_blog_title_class     = '';
							$stomatology_blog_title_link      = '';
							$stomatology_blog_title_link_text = '';
							if ( is_array( $stomatology_blog_title ) ) {
								$stomatology_blog_title_text      = $stomatology_blog_title['text'];
								$stomatology_blog_title_class     = ! empty( $stomatology_blog_title['class'] ) ? ' ' . $stomatology_blog_title['class'] : '';
								$stomatology_blog_title_link      = ! empty( $stomatology_blog_title['link'] ) ? $stomatology_blog_title['link'] : '';
								$stomatology_blog_title_link_text = ! empty( $stomatology_blog_title['link_text'] ) ? $stomatology_blog_title['link_text'] : '';
							} else {
								$stomatology_blog_title_text = $stomatology_blog_title;
							}
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr( $stomatology_blog_title_class ); ?>"<?php
								if ( stomatology_is_on( stomatology_get_theme_option( 'seo_snippets' ) ) ) {
									?> itemprop="headline"<?php
								}
							?>>
								<?php
								$stomatology_top_icon = stomatology_get_term_image_small();
								if ( ! empty( $stomatology_top_icon ) ) {
									$stomatology_attr = stomatology_getimagesize( $stomatology_top_icon );
									?>
									<img src="<?php echo esc_url( $stomatology_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'stomatology' ); ?>"
										<?php
										if ( ! empty( $stomatology_attr[3] ) ) {
											stomatology_show_layout( $stomatology_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $stomatology_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $stomatology_blog_title_link ) && ! empty( $stomatology_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $stomatology_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $stomatology_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'stomatology_action_breadcrumbs' );
						$stomatology_breadcrumbs = ob_get_contents();
						ob_end_clean();
						stomatology_show_layout( $stomatology_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
