<?php
/**
 * The template to show mobile menu (used only header_style == 'default')
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */

$stomatology_show_widgets = stomatology_get_theme_option( 'widgets_menu_mobile_fullscreen' );
$stomatology_show_socials = stomatology_get_theme_option( 'menu_mobile_socials' );

?>
<div class="menu_mobile_overlay scheme_dark"></div>
<div class="menu_mobile menu_mobile_<?php echo esc_attr( stomatology_get_theme_option( 'menu_mobile_fullscreen' ) > 0 ? 'fullscreen' : 'narrow' ); ?> scheme_dark">
	<div class="menu_mobile_inner<?php echo esc_attr( $stomatology_show_widgets == 1  ? ' with_widgets' : '' ); ?>">
        <div class="menu_mobile_header_wrap">
            <?php
            // Logo
            set_query_var( 'stomatology_logo_args', array( 'type' => 'mobile' ) );
            get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/header-logo' ) );
            set_query_var( 'stomatology_logo_args', array() ); ?>

            <a class="menu_mobile_close menu_button_close" tabindex="0"><span class="menu_button_close_text"><?php esc_html_e('Close', 'stomatology')?></span><span class="menu_button_close_icon"></span></a>
        </div>
        <div class="menu_mobile_content_wrap content_wrap">
            <div class="menu_mobile_content_wrap_inner<?php echo esc_attr($stomatology_show_socials ? '' : ' without_socials'); ?>"><?php
            // Mobile menu
            $stomatology_menu_mobile = stomatology_get_nav_menu( 'menu_mobile' );
            if ( empty( $stomatology_menu_mobile ) ) {
                $stomatology_menu_mobile = apply_filters( 'stomatology_filter_get_mobile_menu', '' );
                if ( empty( $stomatology_menu_mobile ) ) {
                    $stomatology_menu_mobile = stomatology_get_nav_menu( 'menu_main' );
                    if ( empty( $stomatology_menu_mobile ) ) {
                        $stomatology_menu_mobile = stomatology_get_nav_menu();
                    }
                }
            }
            if ( ! empty( $stomatology_menu_mobile ) ) {
                // Change attribute 'id' - add prefix 'mobile-' to prevent duplicate id on the page
                $stomatology_menu_mobile = preg_replace( '/([\s]*id=")/', '${1}mobile-', $stomatology_menu_mobile );
                // Change main menu classes
                $stomatology_menu_mobile = str_replace(
                array( 'menu_main',   'sc_layouts_menu_nav', 'sc_layouts_menu ' ), // , 'sc_layouts_hide_on_mobile', 'hide_on_mobile'
                array( 'menu_mobile', '', ' ' ), // , '', ''
                    $stomatology_menu_mobile
                );
                // Wrap menu to the <nav> if not present
                if ( strpos( $stomatology_menu_mobile, '<nav ' ) !== 0 ) {	// condition !== false is not allowed, because menu can contain inner <nav> elements (in the submenu layouts)
				$stomatology_menu_mobile = stomatology_is_on( stomatology_get_theme_option( 'seo_snippets' ) )
					? sprintf( '<nav class="menu_mobile_nav_area" itemscope="itemscope" itemtype="%1$s//schema.org/SiteNavigationElement">%2$s</nav>', esc_attr( stomatology_get_protocol( true ) ), $stomatology_menu_mobile )
					: sprintf( '<nav class="menu_mobile_nav_area">%s</nav>', $stomatology_menu_mobile );
                }
                // Show menu
                stomatology_show_layout( apply_filters( 'stomatology_filter_menu_mobile_layout', $stomatology_menu_mobile ) );
            }
            // Social icons
            if($stomatology_show_socials) {
                stomatology_show_layout( stomatology_get_socials_links(), '<div class="socials_mobile">', '</div>' );
            }            
            ?>
            </div>
		</div><?php

        if ( $stomatology_show_widgets == 1 )  {
            ?><div class="menu_mobile_widgets_area"><?php
            // Create Widgets Area
            stomatology_create_widgets_area( 'widgets_additional_menu_mobile_fullscreen' );
            ?></div><?php
        } ?>

    </div>
</div>
