<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */

$stomatology_args = get_query_var( 'stomatology_logo_args' );

// Site logo
$stomatology_logo_type   = isset( $stomatology_args['type'] ) ? $stomatology_args['type'] : '';
$stomatology_logo_image  = stomatology_get_logo_image( $stomatology_logo_type );
$stomatology_logo_text   = stomatology_is_on( stomatology_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$stomatology_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $stomatology_logo_image['logo'] ) || ! empty( $stomatology_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $stomatology_logo_image['logo'] ) ) {
			if ( empty( $stomatology_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($stomatology_logo_image['logo']) && (int) $stomatology_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$stomatology_attr = stomatology_getimagesize( $stomatology_logo_image['logo'] );
				echo '<img src="' . esc_url( $stomatology_logo_image['logo'] ) . '"'
						. ( ! empty( $stomatology_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $stomatology_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $stomatology_logo_text ) . '"'
						. ( ! empty( $stomatology_attr[3] ) ? ' ' . wp_kses_data( $stomatology_attr[3] ) : '' )
						. '>';
			}
		} else {
			stomatology_show_layout( stomatology_prepare_macros( $stomatology_logo_text ), '<span class="logo_text">', '</span>' );
			stomatology_show_layout( stomatology_prepare_macros( $stomatology_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
