<?php
/**
 * The template to display default site header
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */

$stomatology_header_css   = '';
$stomatology_header_image = get_header_image();
$stomatology_header_video = stomatology_get_header_video();
if ( ! empty( $stomatology_header_image ) && stomatology_trx_addons_featured_image_override( is_singular() || stomatology_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$stomatology_header_image = stomatology_get_current_mode_image( $stomatology_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $stomatology_header_image ) || ! empty( $stomatology_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $stomatology_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $stomatology_header_image ) {
		echo ' ' . esc_attr( stomatology_add_inline_css_class( 'background-image: url(' . esc_url( $stomatology_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( stomatology_is_on( stomatology_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight stomatology-full-height';
	}
	$stomatology_header_scheme = stomatology_get_theme_option( 'header_scheme' );
	if ( ! empty( $stomatology_header_scheme ) && ! stomatology_is_inherit( $stomatology_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $stomatology_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $stomatology_header_video ) ) {
		get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( stomatology_is_on( stomatology_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
