<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0.06
 */

$stomatology_header_css   = '';
$stomatology_header_image = get_header_image();
$stomatology_header_video = stomatology_get_header_video();
if ( ! empty( $stomatology_header_image ) && stomatology_trx_addons_featured_image_override( is_singular() || stomatology_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$stomatology_header_image = stomatology_get_current_mode_image( $stomatology_header_image );
}

$stomatology_header_id = stomatology_get_custom_header_id();
$stomatology_header_meta = get_post_meta( $stomatology_header_id, 'trx_addons_options', true );
if ( ! empty( $stomatology_header_meta['margin'] ) ) {
	stomatology_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( stomatology_prepare_css_value( $stomatology_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $stomatology_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $stomatology_header_id ) ) ); ?>
				<?php
				echo ! empty( $stomatology_header_image ) || ! empty( $stomatology_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $stomatology_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $stomatology_header_image ) {
					echo ' ' . esc_attr( stomatology_add_inline_css_class( 'background-image: url(' . esc_url( $stomatology_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( stomatology_is_on( stomatology_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight stomatology-full-height';
				}
				$stomatology_header_scheme = stomatology_get_theme_option( 'header_scheme' );
				if ( ! empty( $stomatology_header_scheme ) && ! stomatology_is_inherit( $stomatology_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $stomatology_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $stomatology_header_video ) ) {
		get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'stomatology_action_show_layout', $stomatology_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
