<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0.10
 */

// Footer sidebar
$stomatology_footer_name    = stomatology_get_theme_option( 'footer_widgets' );
$stomatology_footer_present = ! stomatology_is_off( $stomatology_footer_name ) && is_active_sidebar( $stomatology_footer_name );
if ( $stomatology_footer_present ) {
	stomatology_storage_set( 'current_sidebar', 'footer' );
	$stomatology_footer_wide = stomatology_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $stomatology_footer_name ) ) {
		dynamic_sidebar( $stomatology_footer_name );
	}
	$stomatology_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $stomatology_out ) ) {
		$stomatology_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $stomatology_out );
		$stomatology_need_columns = true;   //or check: strpos($stomatology_out, 'columns_wrap')===false;
		if ( $stomatology_need_columns ) {
			$stomatology_columns = max( 0, (int) stomatology_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $stomatology_columns ) {
				$stomatology_columns = min( 4, max( 1, stomatology_tags_count( $stomatology_out, 'aside' ) ) );
			}
			if ( $stomatology_columns > 1 ) {
				$stomatology_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $stomatology_columns ) . ' widget', $stomatology_out );
			} else {
				$stomatology_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $stomatology_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'stomatology_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $stomatology_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $stomatology_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'stomatology_action_before_sidebar', 'footer' );
				stomatology_show_layout( $stomatology_out );
				do_action( 'stomatology_action_after_sidebar', 'footer' );
				if ( $stomatology_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $stomatology_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'stomatology_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
