<?php
/**
 * The template to display the site logo in the footer
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0.10
 */

// Logo
if ( stomatology_is_on( stomatology_get_theme_option( 'logo_in_footer' ) ) ) {
	$stomatology_logo_image = stomatology_get_logo_image( 'footer' );
	$stomatology_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $stomatology_logo_image['logo'] ) || ! empty( $stomatology_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $stomatology_logo_image['logo'] ) ) {
					$stomatology_attr = stomatology_getimagesize( $stomatology_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $stomatology_logo_image['logo'] ) . '"'
								. ( ! empty( $stomatology_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $stomatology_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'stomatology' ) . '"'
								. ( ! empty( $stomatology_attr[3] ) ? ' ' . wp_kses_data( $stomatology_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $stomatology_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $stomatology_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
