<?php
/**
 * The template to display default site footer
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0.10
 */

$stomatology_footer_id = stomatology_get_custom_footer_id();
$stomatology_footer_meta = get_post_meta( $stomatology_footer_id, 'trx_addons_options', true );
if ( ! empty( $stomatology_footer_meta['margin'] ) ) {
	stomatology_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( stomatology_prepare_css_value( $stomatology_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $stomatology_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $stomatology_footer_id ) ) ); ?>
						<?php
						$stomatology_footer_scheme = stomatology_get_theme_option( 'footer_scheme' );
						if ( ! empty( $stomatology_footer_scheme ) && ! stomatology_is_inherit( $stomatology_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $stomatology_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'stomatology_action_show_layout', $stomatology_footer_id );
	?>
</footer><!-- /.footer_wrap -->
