<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$stomatology_copyright_scheme = stomatology_get_theme_option( 'copyright_scheme' );
if ( ! empty( $stomatology_copyright_scheme ) && ! stomatology_is_inherit( $stomatology_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $stomatology_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$stomatology_copyright = stomatology_get_theme_option( 'copyright' );
			if ( ! empty( $stomatology_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$stomatology_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $stomatology_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$stomatology_copyright = stomatology_prepare_macros( $stomatology_copyright );
				// Display copyright
				echo wp_kses( nl2br( $stomatology_copyright ), 'stomatology_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
