<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */

$stomatology_template_args = get_query_var( 'stomatology_template_args' );
if ( is_array( $stomatology_template_args ) ) {
	$stomatology_columns    = empty( $stomatology_template_args['columns'] ) ? 2 : max( 1, $stomatology_template_args['columns'] );
	$stomatology_blog_style = array( $stomatology_template_args['type'], $stomatology_columns );
    $stomatology_columns_class = stomatology_get_column_class( 1, $stomatology_columns, ! empty( $stomatology_template_args['columns_tablet']) ? $stomatology_template_args['columns_tablet'] : '', ! empty($stomatology_template_args['columns_mobile']) ? $stomatology_template_args['columns_mobile'] : '' );
} else {
	$stomatology_template_args = array();
	$stomatology_blog_style = explode( '_', stomatology_get_theme_option( 'blog_style' ) );
	$stomatology_columns    = empty( $stomatology_blog_style[1] ) ? 2 : max( 1, $stomatology_blog_style[1] );
    $stomatology_columns_class = stomatology_get_column_class( 1, $stomatology_columns );
}

$stomatology_post_format = get_post_format();
$stomatology_post_format = empty( $stomatology_post_format ) ? 'standard' : str_replace( 'post-format-', '', $stomatology_post_format );

?><div class="
<?php
if ( ! empty( $stomatology_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( stomatology_is_blog_style_use_masonry( $stomatology_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $stomatology_columns ) : esc_attr( $stomatology_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $stomatology_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $stomatology_columns )
		. ( 'portfolio' != $stomatology_blog_style[0] ? ' ' . esc_attr( $stomatology_blog_style[0] )  . '_' . esc_attr( $stomatology_columns ) : '' )
	);
	stomatology_add_blog_animation( $stomatology_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$stomatology_hover   = ! empty( $stomatology_template_args['hover'] ) && ! stomatology_is_inherit( $stomatology_template_args['hover'] )
								? $stomatology_template_args['hover']
								: stomatology_get_theme_option( 'image_hover' );

	if ( 'dots' == $stomatology_hover ) {
		$stomatology_post_link = empty( $stomatology_template_args['no_links'] )
								? ( ! empty( $stomatology_template_args['link'] )
									? $stomatology_template_args['link']
									: get_permalink()
									)
								: '';
		$stomatology_target    = ! empty( $stomatology_post_link ) && stomatology_is_external_url( $stomatology_post_link )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$stomatology_components = ! empty( $stomatology_template_args['meta_parts'] )
							? ( is_array( $stomatology_template_args['meta_parts'] )
								? $stomatology_template_args['meta_parts']
								: explode( ',', $stomatology_template_args['meta_parts'] )
								)
							: stomatology_array_get_keys_by_value( stomatology_get_theme_option( 'meta_parts' ) );

	// Featured image
	stomatology_show_post_featured( apply_filters( 'stomatology_filter_args_featured',
        array(
			'hover'         => $stomatology_hover,
			'no_links'      => ! empty( $stomatology_template_args['no_links'] ),
			'thumb_size'    => ! empty( $stomatology_template_args['thumb_size'] )
								? $stomatology_template_args['thumb_size']
								: stomatology_get_thumb_size(
									stomatology_is_blog_style_use_masonry( $stomatology_blog_style[0] )
										? (	strpos( stomatology_get_theme_option( 'body_style' ), 'full' ) !== false || $stomatology_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( stomatology_get_theme_option( 'body_style' ), 'full' ) !== false || $stomatology_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => stomatology_is_blog_style_use_masonry( $stomatology_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $stomatology_components,
			'class'         => 'dots' == $stomatology_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $stomatology_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $stomatology_post_link )
												? '<a href="' . esc_url( $stomatology_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $stomatology_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $stomatology_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $stomatology_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!