<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0.50
 */

$stomatology_template_args = get_query_var( 'stomatology_template_args' );
if ( is_array( $stomatology_template_args ) ) {
	$stomatology_columns    = empty( $stomatology_template_args['columns'] ) ? 2 : max( 1, $stomatology_template_args['columns'] );
	$stomatology_blog_style = array( $stomatology_template_args['type'], $stomatology_columns );
} else {
	$stomatology_template_args = array();
	$stomatology_blog_style = explode( '_', stomatology_get_theme_option( 'blog_style' ) );
	$stomatology_columns    = empty( $stomatology_blog_style[1] ) ? 2 : max( 1, $stomatology_blog_style[1] );
}
$stomatology_blog_id       = stomatology_get_custom_blog_id( join( '_', $stomatology_blog_style ) );
$stomatology_blog_style[0] = str_replace( 'blog-custom-', '', $stomatology_blog_style[0] );
$stomatology_expanded      = ! stomatology_sidebar_present() && stomatology_get_theme_option( 'expand_content' ) == 'expand';
$stomatology_components    = ! empty( $stomatology_template_args['meta_parts'] )
							? ( is_array( $stomatology_template_args['meta_parts'] )
								? join( ',', $stomatology_template_args['meta_parts'] )
								: $stomatology_template_args['meta_parts']
								)
							: stomatology_array_get_keys_by_value( stomatology_get_theme_option( 'meta_parts' ) );
$stomatology_post_format   = get_post_format();
$stomatology_post_format   = empty( $stomatology_post_format ) ? 'standard' : str_replace( 'post-format-', '', $stomatology_post_format );

$stomatology_blog_meta     = stomatology_get_custom_layout_meta( $stomatology_blog_id );
$stomatology_custom_style  = ! empty( $stomatology_blog_meta['scripts_required'] ) ? $stomatology_blog_meta['scripts_required'] : 'none';

if ( ! empty( $stomatology_template_args['slider'] ) || $stomatology_columns > 1 || ! stomatology_is_off( $stomatology_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $stomatology_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( stomatology_is_off( $stomatology_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $stomatology_custom_style ) ) . "-1_{$stomatology_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $stomatology_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $stomatology_columns )
					. ' post_layout_' . esc_attr( $stomatology_blog_style[0] )
					. ' post_layout_' . esc_attr( $stomatology_blog_style[0] ) . '_' . esc_attr( $stomatology_columns )
					. ( ! stomatology_is_off( $stomatology_custom_style )
						? ' post_layout_' . esc_attr( $stomatology_custom_style )
							. ' post_layout_' . esc_attr( $stomatology_custom_style ) . '_' . esc_attr( $stomatology_columns )
						: ''
						)
		);
	stomatology_add_blog_animation( $stomatology_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'stomatology_action_show_layout', $stomatology_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $stomatology_template_args['slider'] ) || $stomatology_columns > 1 || ! stomatology_is_off( $stomatology_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
