<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */

$stomatology_template_args = get_query_var( 'stomatology_template_args' );

if ( is_array( $stomatology_template_args ) ) {
	$stomatology_columns    = empty( $stomatology_template_args['columns'] ) ? 2 : max( 1, $stomatology_template_args['columns'] );
	$stomatology_blog_style = array( $stomatology_template_args['type'], $stomatology_columns );
    $stomatology_columns_class = stomatology_get_column_class( 1, $stomatology_columns, ! empty( $stomatology_template_args['columns_tablet']) ? $stomatology_template_args['columns_tablet'] : '', ! empty($stomatology_template_args['columns_mobile']) ? $stomatology_template_args['columns_mobile'] : '' );
} else {
	$stomatology_template_args = array();
	$stomatology_blog_style = explode( '_', stomatology_get_theme_option( 'blog_style' ) );
	$stomatology_columns    = empty( $stomatology_blog_style[1] ) ? 2 : max( 1, $stomatology_blog_style[1] );
    $stomatology_columns_class = stomatology_get_column_class( 1, $stomatology_columns );
}
$stomatology_expanded   = ! stomatology_sidebar_present() && stomatology_get_theme_option( 'expand_content' ) == 'expand';

$stomatology_post_format = get_post_format();
$stomatology_post_format = empty( $stomatology_post_format ) ? 'standard' : str_replace( 'post-format-', '', $stomatology_post_format );

?><div class="<?php
	if ( ! empty( $stomatology_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( stomatology_is_blog_style_use_masonry( $stomatology_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $stomatology_columns ) : esc_attr( $stomatology_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $stomatology_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $stomatology_columns )
				. ' post_layout_' . esc_attr( $stomatology_blog_style[0] )
				. ' post_layout_' . esc_attr( $stomatology_blog_style[0] ) . '_' . esc_attr( $stomatology_columns )
	);
	stomatology_add_blog_animation( $stomatology_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$stomatology_hover      = ! empty( $stomatology_template_args['hover'] ) && ! stomatology_is_inherit( $stomatology_template_args['hover'] )
							? $stomatology_template_args['hover']
							: stomatology_get_theme_option( 'image_hover' );

	$stomatology_components = ! empty( $stomatology_template_args['meta_parts'] )
							? ( is_array( $stomatology_template_args['meta_parts'] )
								? $stomatology_template_args['meta_parts']
								: explode( ',', $stomatology_template_args['meta_parts'] )
								)
							: stomatology_array_get_keys_by_value( stomatology_get_theme_option( 'meta_parts' ) );

	stomatology_show_post_featured( apply_filters( 'stomatology_filter_args_featured',
		array(
			'thumb_size' => ! empty( $stomatology_template_args['thumb_size'] )
				? $stomatology_template_args['thumb_size']
				: stomatology_get_thumb_size(
					'classic' == $stomatology_blog_style[0]
						? ( strpos( stomatology_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $stomatology_columns > 2 ? 'big' : 'huge' )
								: ( $stomatology_columns > 2
									? ( $stomatology_expanded ? 'square' : 'square' )
									: ($stomatology_columns > 1 ? 'square' : ( $stomatology_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( stomatology_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $stomatology_columns > 2 ? 'masonry-big' : 'full' )
								: ($stomatology_columns === 1 ? ( $stomatology_expanded ? 'huge' : 'big' ) : ( $stomatology_columns <= 2 && $stomatology_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $stomatology_hover,
			'meta_parts' => $stomatology_components,
			'no_links'   => ! empty( $stomatology_template_args['no_links'] ),
        ),
        'content-classic',
        $stomatology_template_args
    ) );

	// Title and post meta
	$stomatology_show_title = get_the_title() != '';
	$stomatology_show_meta  = count( $stomatology_components ) > 0 && ! in_array( $stomatology_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $stomatology_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'stomatology_filter_show_blog_meta', $stomatology_show_meta, $stomatology_components, 'classic' ) ) {
				if ( count( $stomatology_components ) > 0 ) {
					do_action( 'stomatology_action_before_post_meta' );
					stomatology_show_post_meta(
						apply_filters(
							'stomatology_filter_post_meta_args', array(
							'components' => join( ',', $stomatology_components ),
							'seo'        => false,
							'echo'       => true,
						), $stomatology_blog_style[0], $stomatology_columns
						)
					);
					do_action( 'stomatology_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'stomatology_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'stomatology_action_before_post_title' );
				if ( empty( $stomatology_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'stomatology_action_after_post_title' );
			}

			if( !in_array( $stomatology_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'stomatology_filter_show_blog_readmore', ! $stomatology_show_title || ! empty( $stomatology_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $stomatology_template_args['no_links'] ) ) {
						do_action( 'stomatology_action_before_post_readmore' );
						stomatology_show_post_more_link( $stomatology_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'stomatology_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $stomatology_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('stomatology_filter_show_blog_excerpt', empty($stomatology_template_args['hide_excerpt']) && stomatology_get_theme_option('excerpt_length') > 0, 'classic')) {
			stomatology_show_post_content($stomatology_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $stomatology_template_args['more_button'] )) {
			if ( empty( $stomatology_template_args['no_links'] ) ) {
				do_action( 'stomatology_action_before_post_readmore' );
				stomatology_show_post_more_link( $stomatology_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'stomatology_action_after_post_readmore' );
			}
		}
		$stomatology_content = ob_get_contents();
		ob_end_clean();
		stomatology_show_layout($stomatology_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
