<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.71.0
 */

$stomatology_template_args = get_query_var( 'stomatology_template_args' );
if ( ! is_array( $stomatology_template_args ) ) {
	$stomatology_template_args = array(
								'type'    => 'band',
								'columns' => 1
								);
}

$stomatology_columns       = 1;

$stomatology_expanded      = ! stomatology_sidebar_present() && stomatology_get_theme_option( 'expand_content' ) == 'expand';

$stomatology_post_format   = get_post_format();
$stomatology_post_format   = empty( $stomatology_post_format ) ? 'standard' : str_replace( 'post-format-', '', $stomatology_post_format );

if ( is_array( $stomatology_template_args ) ) {
	$stomatology_columns    = empty( $stomatology_template_args['columns'] ) ? 1 : max( 1, $stomatology_template_args['columns'] );
	$stomatology_blog_style = array( $stomatology_template_args['type'], $stomatology_columns );
	if ( ! empty( $stomatology_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $stomatology_columns > 1 ) {
	    $stomatology_columns_class = stomatology_get_column_class( 1, $stomatology_columns, ! empty( $stomatology_template_args['columns_tablet']) ? $stomatology_template_args['columns_tablet'] : '', ! empty($stomatology_template_args['columns_mobile']) ? $stomatology_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $stomatology_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $stomatology_post_format ) );
	stomatology_add_blog_animation( $stomatology_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$stomatology_hover      = ! empty( $stomatology_template_args['hover'] ) && ! stomatology_is_inherit( $stomatology_template_args['hover'] )
							? $stomatology_template_args['hover']
							: stomatology_get_theme_option( 'image_hover' );
	$stomatology_components = ! empty( $stomatology_template_args['meta_parts'] )
							? ( is_array( $stomatology_template_args['meta_parts'] )
								? $stomatology_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $stomatology_template_args['meta_parts'] ) )
								)
							: stomatology_array_get_keys_by_value( stomatology_get_theme_option( 'meta_parts' ) );
	stomatology_show_post_featured( apply_filters( 'stomatology_filter_args_featured',
		array(
			'no_links'   => ! empty( $stomatology_template_args['no_links'] ),
			'hover'      => $stomatology_hover,
			'meta_parts' => $stomatology_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $stomatology_template_args['thumb_size'] )
								? $stomatology_template_args['thumb_size']
								: stomatology_get_thumb_size( 
								in_array( $stomatology_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( stomatology_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $stomatology_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$stomatology_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$stomatology_show_title = get_the_title() != '';
		$stomatology_show_meta  = count( $stomatology_components ) > 0 && ! in_array( $stomatology_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $stomatology_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'stomatology_filter_show_blog_categories', $stomatology_show_meta && in_array( 'categories', $stomatology_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'stomatology_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						stomatology_show_post_meta( apply_filters(
															'stomatology_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $stomatology_hover, 1
															)
											);
						?>
					</div>
					<?php
					$stomatology_components = stomatology_array_delete_by_value( $stomatology_components, 'categories' );
					do_action( 'stomatology_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'stomatology_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'stomatology_action_before_post_title' );
					if ( empty( $stomatology_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'stomatology_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $stomatology_template_args['excerpt_length'] ) && ! in_array( $stomatology_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$stomatology_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'stomatology_filter_show_blog_excerpt', empty( $stomatology_template_args['hide_excerpt'] ) && stomatology_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				stomatology_show_post_content( $stomatology_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'stomatology_filter_show_blog_meta', $stomatology_show_meta, $stomatology_components, 'band' ) ) {
			if ( count( $stomatology_components ) > 0 ) {
				do_action( 'stomatology_action_before_post_meta' );
				stomatology_show_post_meta(
					apply_filters(
						'stomatology_filter_post_meta_args', array(
							'components' => join( ',', $stomatology_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'stomatology_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'stomatology_filter_show_blog_readmore', ! $stomatology_show_title || ! empty( $stomatology_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $stomatology_template_args['no_links'] ) ) {
				do_action( 'stomatology_action_before_post_readmore' );
				stomatology_show_post_more_link( $stomatology_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'stomatology_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $stomatology_template_args ) ) {
	if ( ! empty( $stomatology_template_args['slider'] ) || $stomatology_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
