<?php
/**
 * The template to display the user's avatar, bio and socials on the Author page
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.71.0
 */
?>

<div class="author_page author vcard"<?php
	if ( stomatology_is_on( stomatology_get_theme_option( 'seo_snippets' ) ) ) {
		?> itemprop="author" itemscope="itemscope" itemtype="<?php echo esc_attr( stomatology_get_protocol( true ) ); ?>//schema.org/Person"<?php
	}
?>>

	<div class="author_avatar"<?php
		if ( stomatology_is_on( stomatology_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="image"<?php
		}
	?>>
		<?php
		$stomatology_mult = stomatology_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $stomatology_mult );
		?>
	</div>

	<h4 class="author_title"<?php
		if ( stomatology_is_on( stomatology_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="name"<?php
		}
	?>><span class="fn"><?php the_author(); ?></span></h4>

	<?php
	$stomatology_author_description = get_the_author_meta( 'description' );
	if ( ! empty( $stomatology_author_description ) ) {
		?>
		<div class="author_bio"<?php
			if ( stomatology_is_on( stomatology_get_theme_option( 'seo_snippets' ) ) ) {
				?> itemprop="description"<?php
			}
		?>><?php echo wp_kses( wpautop( $stomatology_author_description ), 'stomatology_kses_content' ); ?></div>
		<?php
	}
	?>

	<div class="author_details">
		<span class="author_posts_total">
			<?php
			$stomatology_posts_total = count_user_posts( get_the_author_meta('ID'), 'post' );
			if ( $stomatology_posts_total > 0 ) {
				// Translators: Add the author's posts number to the message
				echo wp_kses( sprintf( _n( '%s article published', '%s articles published', $stomatology_posts_total, 'stomatology' ),
										'<span class="author_posts_total_value">' . number_format_i18n( $stomatology_posts_total ) . '</span>'
								 		),
							'stomatology_kses_content'
							);
			} else {
				esc_html_e( 'No posts published.', 'stomatology' );
			}
			?>
		</span><?php
			ob_start();
			do_action( 'stomatology_action_user_meta', 'author-page' );
			$stomatology_socials = ob_get_contents();
			ob_end_clean();
			stomatology_show_layout( $stomatology_socials,
				'<span class="author_socials"><span class="author_socials_caption">' . esc_html__( 'Follow:', 'stomatology' ) . '</span>',
				'</span>'
			);
		?>
	</div>

</div>
