<?php
/**
 * The template to display Admin notices
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0.1
 */

$stomatology_theme_slug = get_option( 'template' );
$stomatology_theme_obj  = wp_get_theme( $stomatology_theme_slug );
?>
<div class="stomatology_admin_notice stomatology_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$stomatology_theme_img = stomatology_get_file_url( 'screenshot.jpg' );
	if ( '' != $stomatology_theme_img ) {
		?>
		<div class="stomatology_notice_image"><img src="<?php echo esc_url( $stomatology_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'stomatology' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="stomatology_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'stomatology' ),
				$stomatology_theme_obj->get( 'Name' ) . ( STOMATOLOGY_THEME_FREE ? ' ' . __( 'Free', 'stomatology' ) : '' ),
				$stomatology_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="stomatology_notice_text">
		<p class="stomatology_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $stomatology_theme_obj->description ) );
			?>
		</p>
		<p class="stomatology_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'stomatology' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="stomatology_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=stomatology_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'stomatology' );
			?>
		</a>
	</div>
</div>
