<?php
/**
 * Skin Setup
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.76.0
 */


//--------------------------------------------
// SKIN DEFAULTS
//--------------------------------------------

// Return theme's (skin's) default value for the specified parameter
if ( ! function_exists( 'stomatology_theme_defaults' ) ) {
    function stomatology_theme_defaults( $name = '', $value = '' ) {
        $defaults = array(
            'page_width'          => 1290,
            'page_boxed_extra'  => 60,
            'page_fullwide_max' => 1920,
            'page_fullwide_extra' => 60,
            'sidebar_width'       => 410,
            'sidebar_gap'       => 40,
            'grid_gap'          => 30,
            'rad'               => 0
        );
        if ( empty( $name ) ) {
            return $defaults;
        } else {
            if ( $value === '' && isset( $defaults[ $name ] ) ) {
                $value = $defaults[ $name ];
            }
            return $value;
        }
    }
}


// WOOCOMMERCE SETUP
//--------------------------------------------------

// Allow extended layouts for WooCommerce
if ( ! function_exists( 'stomatology_skin_woocommerce_allow_extensions' ) ) {
    add_filter( 'stomatology_filter_load_woocommerce_extensions', 'stomatology_skin_woocommerce_allow_extensions' );
    function stomatology_skin_woocommerce_allow_extensions( $allow ) {
        return false;
    }
}


// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)


//--------------------------------------------
// SKIN SETTINGS
//--------------------------------------------
if ( ! function_exists( 'stomatology_skin_setup' ) ) {
    add_action( 'after_setup_theme', 'stomatology_skin_setup', 1 );
    function stomatology_skin_setup() {

        $GLOBALS['STOMATOLOGY_STORAGE'] = array_merge( $GLOBALS['STOMATOLOGY_STORAGE'], array(

            // Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
            'theme_pro_key'       => 'env-axiom',

            'theme_doc_url'       => '//doc.themerex.net/stomatology/',

            'theme_demofiles_url' => '//demofiles.axiomthemes.com/stomatology/',
            
            'theme_rate_url'      => '//themeforest.net/downloads',

            'theme_custom_url'    => '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themeinstall',

            'theme_support_url'   => '//themerex.net/support/',

            'theme_download_url'  => '//themeforest.net/user/axiomthemes/portfolio',         // Axiom

            'theme_video_url'     => '//www.youtube.com/channel/UCBjqhuwKj3MfE3B6Hg2oA8Q',   // Axiom

            'theme_privacy_url'   => '//axiomthemes.com/privacy-policy/',                    // Axiom

            'portfolio_url'       => '//themeforest.net/user/axiomthemes/portfolio',         // Axiom

            // Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
            // (i.e. 'children,kindergarten')
            'theme_categories'    => '',
        ) );
    }
}


// Add/remove/change Theme Settings
if ( ! function_exists( 'stomatology_skin_setup_settings' ) ) {
    add_action( 'after_setup_theme', 'stomatology_skin_setup_settings', 1 );
    function stomatology_skin_setup_settings() {
        // Example: enable (true) / disable (false) thumbs in the prev/next navigation
        stomatology_storage_set_array( 'settings', 'thumbs_in_navigation', false );
        stomatology_storage_set_array2( 'required_plugins', 'instagram-feed', 'install', false );
        stomatology_storage_set_array2( 'required_plugins', 'quickcal', 'install', true );
        stomatology_storage_set_array2( 'required_plugins', 'revslider', 'install', true );
        stomatology_storage_set_array2( 'required_plugins', 'woocommerce', 'install', true );
        stomatology_storage_set_array2( 'required_plugins', 'ti-woocommerce-wishlist', 'install', true );
        stomatology_storage_set_array2( 'required_plugins', 'woo-smart-quick-view', 'install', true );
    }
}



//--------------------------------------------
// SKIN FONTS
//--------------------------------------------
if ( ! function_exists( 'stomatology_skin_setup_fonts' ) ) {
    add_action( 'after_setup_theme', 'stomatology_skin_setup_fonts', 1 );
    function stomatology_skin_setup_fonts() {
        // Fonts to load when theme start
        // It can be:
        // - Google fonts (specify name, family and styles)
        // - Adobe fonts (specify name, family and link URL)
        // - uploaded fonts (specify name, family), placed in the folder css/font-face/font-name inside the skin folder
        // Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
        // example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
        stomatology_storage_set(
            'load_fonts', array(
                array(
                    'name'   => 'stolzl',
                    'family' => 'sans-serif',
                    'link'   => 'https://use.typekit.net/pjg1ebb.css',
                    'styles' => ''
                ),
                // Google font
                array(
                    'name'   => 'DM Sans',
                    'family' => 'sans-serif',
                    'link'   => '',
                    'styles' => 'ital,wght@0,400;0,500;0,700;1,400;1,500;1,700',     // Parameter 'style' used only for the Google fonts
                ),
            )
        );

        // Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
        stomatology_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

        // Settings of the main tags.
        // Default value of 'font-family' may be specified as reference to the array $load_fonts (see above)
        // or as comma-separated string.
        // In the second case (if 'font-family' is specified manually as comma-separated string):
        //    1) Font name with spaces in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
        //    2) If font-family inherit a value from the 'Main text' - specify 'inherit' as a value
        // example:
        // Correct:   'font-family' => stomatology_get_load_fonts_family_string( $load_fonts[0] )
        // Correct:   'font-family' => 'Roboto,sans-serif'
        // Correct:   'font-family' => '"PT Serif",sans-serif'
        // Incorrect: 'font-family' => 'Roboto, sans-serif'
        // Incorrect: 'font-family' => 'PT Serif,sans-serif'

        $font_description = esc_html__( 'Please use only the following units: "rem" or "em".', 'stomatology' )
                            . ( is_customize_preview() ? '<br>' . esc_html__( 'Press "Reload preview area" button at the top of this panel after the all font parameters are changed.', 'stomatology' ) : '' );

        stomatology_storage_set(
            'theme_fonts', array(
                'p'       => array(
                    'title'           => esc_html__( 'Main text', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'main text', 'stomatology' ) ),
                    'font-family'     => '"DM Sans",sans-serif',
                    'font-size'       => '1rem',
                    'font-weight'     => '400',
                    'font-style'      => 'normal',
                    'line-height'     => '1.647em',
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '0px',
                    'margin-top'      => '0em',
                    'margin-bottom'   => '1.57em',
                ),
                'post'    => array(
                    'title'           => esc_html__( 'Article text', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'article text', 'stomatology' ) ),
                    'font-family'     => 'inherit',        // Example: '"PR Serif",serif',
                    'font-size'       => '',            // Example: '1.286rem',
                    'font-weight'     => 'inherit',        // Example: '400',
                    'font-style'      => 'inherit',        // Example: 'normal',
                    'line-height'     => '',            // Example: '1.75em',
                    'text-decoration' => 'inherit',        // Example: 'none',
                    'text-transform'  => 'inherit',        // Example: 'none',
                    'letter-spacing'  => '',            // Example: '',
                    'margin-top'      => '',            // Example: '0em',
                    'margin-bottom'   => '',            // Example: '1.4em',
                ),
                'h1'      => array(
                    'title'           => esc_html__( 'Heading 1', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'tag H1', 'stomatology' ) ),
                    'font-family'     => 'stolzl,sans-serif',
                    'font-size'       => '3.353em',
                    'font-weight'     => '500',
                    'font-style'      => 'normal',
                    'line-height'     => '1.053em',
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '-1.8px',
                    'margin-top'      => '1.04em',
                    'margin-bottom'   => '0.46em',
                ),
                'h2'      => array(
                    'title'           => esc_html__( 'Heading 2', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'tag H2', 'stomatology' ) ),
                    'font-family'     => 'stolzl,sans-serif',
                    'font-size'       => '2.765em',
                    'font-weight'     => '500',
                    'font-style'      => 'normal',
                    'line-height'     => '1.07em',
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '0px',
                    'margin-top'      => '0.67em',
                    'margin-bottom'   => '0.56em',
                ),
                'h3'      => array(
                    'title'           => esc_html__( 'Heading 3', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'tag H3', 'stomatology' ) ),
                    'font-family'     => 'stolzl,sans-serif',
                    'font-size'       => '2.059em',
                    'font-weight'     => '500',
                    'font-style'      => 'normal',
                    'line-height'     => '1.086em',
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '0px',
                    'margin-top'      => '0.94em',
                    'margin-bottom'   => '0.72em',
                ),
                'h4'      => array(
                    'title'           => esc_html__( 'Heading 4', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'tag H4', 'stomatology' ) ),
                    'font-family'     => 'stolzl,sans-serif',
                    'font-size'       => '1.647em',
                    'font-weight'     => '500',
                    'font-style'      => 'normal',
                    'line-height'     => '1.214em',
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '0px',
                    'margin-top'      => '1.15em',
                    'margin-bottom'   => '0.83em',
                ),
                'h5'      => array(
                    'title'           => esc_html__( 'Heading 5', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'tag H5', 'stomatology' ) ),
                    'font-family'     => 'stolzl,sans-serif',
                    'font-size'       => '1.412em',
                    'font-weight'     => '500',
                    'font-style'      => 'normal',
                    'line-height'     => '1.208em',
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '0px',
                    'margin-top'      => '1.3em',
                    'margin-bottom'   => '0.84em',
                ),
                'h6'      => array(
                    'title'           => esc_html__( 'Heading 6', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'tag H6', 'stomatology' ) ),
                    'font-family'     => 'stolzl,sans-serif',
                    'font-size'       => '1.118em',
                    'font-weight'     => '500',
                    'font-style'      => 'normal',
                    'line-height'     => '1.474em',
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '0px',
                    'margin-top'      => '1.75em',
                    'margin-bottom'   => '1.1em',
                ),
                'logo'    => array(
                    'title'           => esc_html__( 'Logo text', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'text of the logo', 'stomatology' ) ),
                    'font-family'     => 'stolzl,sans-serif',
                    'font-size'       => '1.7em',
                    'font-weight'     => '500',
                    'font-style'      => 'normal',
                    'line-height'     => '1.25em',
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '0px',
                ),
                'button'  => array(
                    'title'           => esc_html__( 'Buttons', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'buttons', 'stomatology' ) ),
                    'font-family'     => 'stolzl,sans-serif',
                    'font-size'       => '14px',
                    'font-weight'     => '400',
                    'font-style'      => 'normal',
                    'line-height'     => '21px',
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '0px',
                ),
                'input'   => array(
                    'title'           => esc_html__( 'Input fields', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'input fields, dropdowns and textareas', 'stomatology' ) ),
                    'font-family'     => 'inherit',
                    'font-size'       => '16px',
                    'font-weight'     => '400',
                    'font-style'      => 'normal',
                    'line-height'     => '1.5em',     // Attention! Firefox don't allow line-height less then 1.5em in the select
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '0.1px',
                ),
                'info'    => array(
                    'title'           => esc_html__( 'Post meta', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'post meta (author, categories, publish date, counters, share, etc.)', 'stomatology' ) ),
                    'font-family'     => 'inherit',
                    'font-size'       => '14px',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
                    'font-weight'     => '400',
                    'font-style'      => 'normal',
                    'line-height'     => '1.5em',
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '0px',
                    'margin-top'      => '0.4em',
                    'margin-bottom'   => '',
                ),
                'menu'    => array(
                    'title'           => esc_html__( 'Main menu', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'main menu items', 'stomatology' ) ),
                    'font-family'     => 'stolzl,sans-serif',
                    'font-size'       => '14px',
                    'font-weight'     => '400',
                    'font-style'      => 'normal',
                    'line-height'     => '1.5em',
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '0px',
                ),
                'submenu' => array(
                    'title'           => esc_html__( 'Dropdown menu', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'dropdown menu items', 'stomatology' ) ),
                    'font-family'     => '"DM Sans",sans-serif',
                    'font-size'       => '15px',
                    'font-weight'     => '400',
                    'font-style'      => 'normal',
                    'line-height'     => '1.5em',
                    'text-decoration' => 'none',
                    'text-transform'  => 'none',
                    'letter-spacing'  => '0px',
                ),
                'other' => array(
                    'title'           => esc_html__( 'Other', 'stomatology' ),
                    'description'     => sprintf( $font_description, esc_html__( 'specific elements', 'stomatology' ) ),
                    'font-family'     => '"DM Sans",sans-serif',
                ),
            )
        );

        // Font presets
        stomatology_storage_set(
            'font_presets', array(
                'karla' => array(
                                'title'  => esc_html__( 'Karla', 'stomatology' ),
                                'load_fonts' => array(
                                                    // Google font
                                                    array(
                                                        'name'   => 'Dancing Script',
                                                        'family' => 'fantasy',
                                                        'link'   => '',
                                                        'styles' => '300,400,700',
                                                    ),
                                                    // Google font
                                                    array(
                                                        'name'   => 'Sansita Swashed',
                                                        'family' => 'fantasy',
                                                        'link'   => '',
                                                        'styles' => '300,400,700',
                                                    ),
                                                ),
                                'theme_fonts' => array(
                                                    'p'       => array(
                                                        'font-family'     => '"Dancing Script",fantasy',
                                                        'font-size'       => '1.25rem',
                                                    ),
                                                    'post'    => array(
                                                        'font-family'     => '',
                                                    ),
                                                    'h1'      => array(
                                                        'font-family'     => '"Sansita Swashed",fantasy',
                                                        'font-size'       => '4em',
                                                    ),
                                                    'h2'      => array(
                                                        'font-family'     => '"Sansita Swashed",fantasy',
                                                    ),
                                                    'h3'      => array(
                                                        'font-family'     => '"Sansita Swashed",fantasy',
                                                    ),
                                                    'h4'      => array(
                                                        'font-family'     => '"Sansita Swashed",fantasy',
                                                    ),
                                                    'h5'      => array(
                                                        'font-family'     => '"Sansita Swashed",fantasy',
                                                    ),
                                                    'h6'      => array(
                                                        'font-family'     => '"Sansita Swashed",fantasy',
                                                    ),
                                                    'logo'    => array(
                                                        'font-family'     => '"Sansita Swashed",fantasy',
                                                    ),
                                                    'button'  => array(
                                                        'font-family'     => '"Sansita Swashed",fantasy',
                                                    ),
                                                    'input'   => array(
                                                        'font-family'     => 'inherit',
                                                    ),
                                                    'info'    => array(
                                                        'font-family'     => 'inherit',
                                                    ),
                                                    'menu'    => array(
                                                        'font-family'     => '"Sansita Swashed",fantasy',
                                                    ),
                                                    'submenu' => array(
                                                        'font-family'     => '"Sansita Swashed",fantasy',
                                                    ),
                                                ),
                            ),
                'roboto' => array(
                                'title'  => esc_html__( 'Roboto', 'stomatology' ),
                                'load_fonts' => array(
                                                    // Google font
                                                    array(
                                                        'name'   => 'Noto Sans JP',
                                                        'family' => 'serif',
                                                        'link'   => '',
                                                        'styles' => '300,300italic,400,400italic,700,700italic',
                                                    ),
                                                    // Google font
                                                    array(
                                                        'name'   => 'Merriweather',
                                                        'family' => 'sans-serif',
                                                        'link'   => '',
                                                        'styles' => '300,300italic,400,400italic,700,700italic',
                                                    ),
                                                ),
                                'theme_fonts' => array(
                                                    'p'       => array(
                                                        'font-family'     => '"Noto Sans JP",serif',
                                                    ),
                                                    'post'    => array(
                                                        'font-family'     => '',
                                                    ),
                                                    'h1'      => array(
                                                        'font-family'     => 'Merriweather,sans-serif',
                                                    ),
                                                    'h2'      => array(
                                                        'font-family'     => 'Merriweather,sans-serif',
                                                    ),
                                                    'h3'      => array(
                                                        'font-family'     => 'Merriweather,sans-serif',
                                                    ),
                                                    'h4'      => array(
                                                        'font-family'     => 'Merriweather,sans-serif',
                                                    ),
                                                    'h5'      => array(
                                                        'font-family'     => 'Merriweather,sans-serif',
                                                    ),
                                                    'h6'      => array(
                                                        'font-family'     => 'Merriweather,sans-serif',
                                                    ),
                                                    'logo'    => array(
                                                        'font-family'     => 'Merriweather,sans-serif',
                                                    ),
                                                    'button'  => array(
                                                        'font-family'     => 'Merriweather,sans-serif',
                                                    ),
                                                    'input'   => array(
                                                        'font-family'     => 'inherit',
                                                    ),
                                                    'info'    => array(
                                                        'font-family'     => 'inherit',
                                                    ),
                                                    'menu'    => array(
                                                        'font-family'     => 'Merriweather,sans-serif',
                                                    ),
                                                    'submenu' => array(
                                                        'font-family'     => 'Merriweather,sans-serif',
                                                    ),
                                                ),
                            ),
                'garamond' => array(
                                'title'  => esc_html__( 'Garamond', 'stomatology' ),
                                'load_fonts' => array(
                                                    // Adobe font
                                                    array(
                                                        'name'   => 'Europe',
                                                        'family' => 'sans-serif',
                                                        'link'   => 'https://use.typekit.net/qmj1tmx.css',
                                                        'styles' => '',
                                                    ),
                                                    // Adobe font
                                                    array(
                                                        'name'   => 'Sofia Pro',
                                                        'family' => 'sans-serif',
                                                        'link'   => 'https://use.typekit.net/qmj1tmx.css',
                                                        'styles' => '',
                                                    ),
                                                ),
                                'theme_fonts' => array(
                                                    'p'       => array(
                                                        'font-family'     => '"Sofia Pro",sans-serif',
                                                    ),
                                                    'post'    => array(
                                                        'font-family'     => '',
                                                    ),
                                                    'h1'      => array(
                                                        'font-family'     => 'Europe,sans-serif',
                                                    ),
                                                    'h2'      => array(
                                                        'font-family'     => 'Europe,sans-serif',
                                                    ),
                                                    'h3'      => array(
                                                        'font-family'     => 'Europe,sans-serif',
                                                    ),
                                                    'h4'      => array(
                                                        'font-family'     => 'Europe,sans-serif',
                                                    ),
                                                    'h5'      => array(
                                                        'font-family'     => 'Europe,sans-serif',
                                                    ),
                                                    'h6'      => array(
                                                        'font-family'     => 'Europe,sans-serif',
                                                    ),
                                                    'logo'    => array(
                                                        'font-family'     => 'Europe,sans-serif',
                                                    ),
                                                    'button'  => array(
                                                        'font-family'     => 'Europe,sans-serif',
                                                    ),
                                                    'input'   => array(
                                                        'font-family'     => 'inherit',
                                                    ),
                                                    'info'    => array(
                                                        'font-family'     => 'inherit',
                                                    ),
                                                    'menu'    => array(
                                                        'font-family'     => 'Europe,sans-serif',
                                                    ),
                                                    'submenu' => array(
                                                        'font-family'     => 'Europe,sans-serif',
                                                    ),
                                                ),
                            ),
            )
        );
    }
}


//--------------------------------------------
// COLOR SCHEMES
//--------------------------------------------
if ( ! function_exists( 'stomatology_skin_setup_schemes' ) ) {
    add_action( 'after_setup_theme', 'stomatology_skin_setup_schemes', 1 );
    function stomatology_skin_setup_schemes() {

        // Theme colors for customizer
        // Attention! Inner scheme must be last in the array below
        stomatology_storage_set(
            'scheme_color_groups', array(
                'main'    => array(
                    'title'       => esc_html__( 'Main', 'stomatology' ),
                    'description' => esc_html__( 'Colors of the main content area', 'stomatology' ),
                ),
                'alter'   => array(
                    'title'       => esc_html__( 'Alter', 'stomatology' ),
                    'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'stomatology' ),
                ),
                'extra'   => array(
                    'title'       => esc_html__( 'Extra', 'stomatology' ),
                    'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'stomatology' ),
                ),
                'inverse' => array(
                    'title'       => esc_html__( 'Inverse', 'stomatology' ),
                    'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'stomatology' ),
                ),
                'input'   => array(
                    'title'       => esc_html__( 'Input', 'stomatology' ),
                    'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'stomatology' ),
                ),
            )
        );

        stomatology_storage_set(
            'scheme_color_names', array(
                'bg_color'    => array(
                    'title'       => esc_html__( 'Background color', 'stomatology' ),
                    'description' => esc_html__( 'Background color of this block in the normal state', 'stomatology' ),
                ),
                'bg_hover'    => array(
                    'title'       => esc_html__( 'Background hover', 'stomatology' ),
                    'description' => esc_html__( 'Background color of this block in the hovered state', 'stomatology' ),
                ),
                'bd_color'    => array(
                    'title'       => esc_html__( 'Border color', 'stomatology' ),
                    'description' => esc_html__( 'Border color of this block in the normal state', 'stomatology' ),
                ),
                'bd_hover'    => array(
                    'title'       => esc_html__( 'Border hover', 'stomatology' ),
                    'description' => esc_html__( 'Border color of this block in the hovered state', 'stomatology' ),
                ),
                'text'        => array(
                    'title'       => esc_html__( 'Text', 'stomatology' ),
                    'description' => esc_html__( 'Color of the text inside this block', 'stomatology' ),
                ),
                'text_dark'   => array(
                    'title'       => esc_html__( 'Text dark', 'stomatology' ),
                    'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'stomatology' ),
                ),
                'text_light'  => array(
                    'title'       => esc_html__( 'Text light', 'stomatology' ),
                    'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'stomatology' ),
                ),
                'text_link'   => array(
                    'title'       => esc_html__( 'Link', 'stomatology' ),
                    'description' => esc_html__( 'Color of the links inside this block', 'stomatology' ),
                ),
                'text_hover'  => array(
                    'title'       => esc_html__( 'Link hover', 'stomatology' ),
                    'description' => esc_html__( 'Color of the hovered state of links inside this block', 'stomatology' ),
                ),
                'text_link2'  => array(
                    'title'       => esc_html__( 'Accent 2', 'stomatology' ),
                    'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'stomatology' ),
                ),
                'text_hover2' => array(
                    'title'       => esc_html__( 'Accent 2 hover', 'stomatology' ),
                    'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'stomatology' ),
                ),
                'text_link3'  => array(
                    'title'       => esc_html__( 'Accent 3', 'stomatology' ),
                    'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'stomatology' ),
                ),
                'text_hover3' => array(
                    'title'       => esc_html__( 'Accent 3 hover', 'stomatology' ),
                    'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'stomatology' ),
                ),
            )
        );

        // Default values for each color scheme
        $schemes = array(

            // Color scheme: 'default'
            'default' => array(
                'title'    => esc_html__( 'Default', 'stomatology' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#F7F9FB',
                    'bd_color'         => '#D0D6DD',

                    // Text and links colors
                    'text'             => '#6E7276',
                    'text_light'       => '#85898D',
                    'text_dark'        => '#2B2B2D',
                    'text_link'        => '#00BDE0',
                    'text_hover'       => '#00ABCB',
                    'text_link2'       => '#135DE8',
                    'text_hover2'      => '#0A4CC7',
                    'text_link3'       => '#0BBE50',
                    'text_hover3'      => '#07A544',

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#FFFFFF',
                    'alter_bg_hover'   => '#E7ECF0',
                    'alter_bd_color'   => '#D0D6DD',
                    'alter_bd_hover'   => '#BABBBE',
                    'alter_text'       => '#6E7276',
                    'alter_light'      => '#85898D',
                    'alter_dark'       => '#2B2B2D',
                    'alter_link'       => '#00BDE0',
                    'alter_hover'      => '#00ABCB',
                    'alter_link2'      => '#135DE8',
                    'alter_hover2'     => '#0A4CC7',
                    'alter_link3'      => '#0BBE50',
                    'alter_hover3'     => '#07A544',

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#010104',
                    'extra_bg_hover'   => '#20223C',
                    'extra_bd_color'   => '#2A2D4A',
                    'extra_bd_hover'   => '#3B3F60',
                    'extra_text'       => '#ABACB7',
                    'extra_light'      => '#7F8490',
                    'extra_dark'       => '#FDFDFD',
                    'extra_link'       => '#00BDE0',
                    'extra_hover'      => '#FDFDFD',
                    'extra_link2'      => '#80d572',
                    'extra_hover2'     => '#8be77c',
                    'extra_link3'      => '#ddb837',
                    'extra_hover3'     => '#eec432',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent',
                    'input_bg_hover'   => 'transparent',
                    'input_bd_color'   => '#D0D6DD',
                    'input_bd_hover'   => '#BABBBE',
                    'input_text'       => '#6E7276',
                    'input_light'      => '#85898D',
                    'input_dark'       => '#2B2B2D',

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#1d1d1d',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#2B2B2D',
                    'inverse_link'     => '#FFFFFF',
                    'inverse_hover'    => '#FFFFFF',

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'dark'
            'dark'    => array(
                'title'    => esc_html__( 'Dark', 'stomatology' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#06071C',
                    'bd_color'         => '#3B3F60',

                    // Text and links colors
                    'text'             => '#ABACB7',
                    'text_light'       => '#7F8490',
                    'text_dark'        => '#FDFDFD',
                    'text_link'        => '#00BDE0',
                    'text_hover'       => '#00ABCB',
                    'text_link2'       => '#135DE8',
                    'text_hover2'      => '#0A4CC7',
                    'text_link3'       => '#0BBE50',
                    'text_hover3'      => '#07A544',

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#0C0F2F',
                    'alter_bg_hover'   => '#20223C',
                    'alter_bd_color'   => '#3B3F60',
                    'alter_bd_hover'   => '#ABACB7',
                    'alter_text'       => '#ABACB7',
                    'alter_light'      => '#7F8490',
                    'alter_dark'       => '#FDFDFD',
                    'alter_link'       => '#00BDE0',
                    'alter_hover'      => '#00ABCB',
                    'alter_link2'      => '#135DE8',
                    'alter_hover2'     => '#0A4CC7',
                    'alter_link3'      => '#0BBE50',
                    'alter_hover3'     => '#07A544',

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#010104',
                    'extra_bg_hover'   => '#20223C',
                    'extra_bd_color'   => '#2A2D4A',
                    'extra_bd_hover'   => '#3B3F60',
                    'extra_text'       => '#ABACB7',
                    'extra_light'      => '#7F8490',
                    'extra_dark'       => '#FDFDFD',
                    'extra_link'       => '#00BDE0',
                    'extra_hover'      => '#FDFDFD',
                    'extra_link2'      => '#80d572',
                    'extra_hover2'     => '#8be77c',
                    'extra_link3'      => '#ddb837',
                    'extra_hover3'     => '#eec432',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => '#transparent',
                    'input_bg_hover'   => '#transparent',
                    'input_bd_color'   => '#3B3F60',
                    'input_bd_hover'   => '#3B3F60',
                    'input_text'       => '#ABACB7',
                    'input_light'      => '#7F8490',
                    'input_dark'       => '#FDFDFD',

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#e36650',
                    'inverse_bd_hover' => '#cb5b47',
                    'inverse_text'     => '#F9F9F9',
                    'inverse_light'    => '#6f6f6f',
                    'inverse_dark'     => '#2B2B2D',
                    'inverse_link'     => '#FDFDFD',
                    'inverse_hover'    => '#2B2B2D',

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'light'
            'light' => array(
                'title'    => esc_html__( 'Light', 'stomatology' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#FFFFFF',
                    'bd_color'         => '#D0D6DD',

                    // Text and links colors
                    'text'             => '#6E7276',
                    'text_light'       => '#85898D',
                    'text_dark'        => '#2B2B2D',
                    'text_link'        => '#00BDE0',
                    'text_hover'       => '#00ABCB',
                    'text_link2'       => '#135DE8',
                    'text_hover2'      => '#0A4CC7',
                    'text_link3'       => '#0BBE50',
                    'text_hover3'      => '#07A544',

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#F7F9FB',
                    'alter_bg_hover'   => '#E7ECF0',
                    'alter_bd_color'   => '#D0D6DD',
                    'alter_bd_hover'   => '#BABBBE',
                    'alter_text'       => '#6E7276',
                    'alter_light'      => '#85898D',
                    'alter_dark'       => '#2B2B2D',
                    'alter_link'       => '#00BDE0',
                    'alter_hover'      => '#00ABCB',
                    'alter_link2'      => '#135DE8',
                    'alter_hover2'     => '#0A4CC7',
                    'alter_link3'      => '#0BBE50',
                    'alter_hover3'     => '#07A544',

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#010104',
                    'extra_bg_hover'   => '#20223C',
                    'extra_bd_color'   => '#2A2D4A',
                    'extra_bd_hover'   => '#3B3F60',
                    'extra_text'       => '#ABACB7',
                    'extra_light'      => '#7F8490',
                    'extra_dark'       => '#FDFDFD',
                    'extra_link'       => '#00BDE0',
                    'extra_hover'      => '#FDFDFD',
                    'extra_link2'      => '#80d572',
                    'extra_hover2'     => '#8be77c',
                    'extra_link3'      => '#ddb837',
                    'extra_hover3'     => '#eec432',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent',
                    'input_bg_hover'   => 'transparent',
                    'input_bd_color'   => '#D0D6DD',
                    'input_bd_hover'   => '#BABBBE',
                    'input_text'       => '#6E7276',
                    'input_light'      => '#85898D',
                    'input_dark'       => '#2B2B2D',

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#1d1d1d',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#2B2B2D',
                    'inverse_link'     => '#FFFFFF',
                    'inverse_hover'    => '#FFFFFF',

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'turquoise_default'
            'turquoise_default' => array(
                'title'    => esc_html__( 'Turquoise Default', 'stomatology' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#F2F7FC',
                    'bd_color'         => '#D0D6DD',

                    // Text and links colors
                    'text'             => '#6E7276',
                    'text_light'       => '#85898D',
                    'text_dark'        => '#2B2B2D',
                    'text_link'        => '#229FB2',
                    'text_hover'       => '#1E8FA0',
                    'text_link2'       => '#FF4F25',
                    'text_hover2'      => '#E54721',
                    'text_link3'       => '#A0B22B',
                    'text_hover3'      => '#90A026',

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#FFFFFF',
                    'alter_bg_hover'   => '#E7ECF0',
                    'alter_bd_color'   => '#D0D6DD',
                    'alter_bd_hover'   => '#C0C5CB',
                    'alter_text'       => '#6E7276',
                    'alter_light'      => '#85898D',
                    'alter_dark'       => '#2B2B2D',
                    'alter_link'       => '#229FB2',
                    'alter_hover'      => '#1E8FA0',
                    'alter_link2'      => '#FF4F25',
                    'alter_hover2'     => '#E54721',
                    'alter_link3'      => '#A0B22B',
                    'alter_hover3'     => '#90A026',

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#05090D',
                    'extra_bg_hover'   => '#0E1821',
                    'extra_bd_color'   => '#272F37',
                    'extra_bd_hover'   => '#323A43',
                    'extra_text'       => '#D3D5D6',
                    'extra_light'      => '#B6B9BC',
                    'extra_dark'       => '#FEFEFE',
                    'extra_link'       => '#229FB2',
                    'extra_hover'      => '#FFFFFF',
                    'extra_link2'      => '#80d572',
                    'extra_hover2'     => '#8be77c',
                    'extra_link3'      => '#ddb837',
                    'extra_hover3'     => '#eec432',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent',
                    'input_bg_hover'   => 'transparent',
                    'input_bd_color'   => '#D0D6DD',
                    'input_bd_hover'   => '#C0C5CB',
                    'input_text'       => '#6E7276',
                    'input_light'      => '#85898D',
                    'input_dark'       => '#2B2B2D',

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#1d1d1d',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#2B2B2D',
                    'inverse_link'     => '#FFFFFF',
                    'inverse_hover'    => '#FFFFFF',

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'turquoise_dark'
            'turquoise_dark'    => array(
                'title'    => esc_html__( 'Turquoise Dark', 'stomatology' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#0E1821',
                    'bd_color'         => '#272F37',

                    // Text and links colors
                    'text'             => '#D3D5D6',
                    'text_light'       => '#B6B9BC',
                    'text_dark'        => '#FEFEFE',
                    'text_link'        => '#229FB2',
                    'text_hover'       => '#1E8FA0',
                    'text_link2'       => '#FF4F25',
                    'text_hover2'      => '#E54721',
                    'text_link3'       => '#A0B22B',
                    'text_hover3'      => '#90A026',

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#121E2A',
                    'alter_bg_hover'   => '#0E1821',
                    'alter_bd_color'   => '#0E1821',
                    'alter_bd_hover'   => '#323A43',
                    'alter_text'       => '#D3D5D6',
                    'alter_light'      => '#B6B9BC',
                    'alter_dark'       => '#FEFEFE',
                    'alter_link'       => '#229FB2',
                    'alter_hover'      => '#1E8FA0',
                    'alter_link2'      => '#FF4F25',
                    'alter_hover2'     => '#E54721',
                    'alter_link3'      => '#A0B22B',
                    'alter_hover3'     => '#90A026',

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#05090D',
                    'extra_bg_hover'   => '#0E1821',
                    'extra_bd_color'   => '#272F37',
                    'extra_bd_hover'   => '#323A43',
                    'extra_text'       => '#D3D5D6',
                    'extra_light'      => '#B6B9BC',
                    'extra_dark'       => '#FEFEFE',
                    'extra_link'       => '#229FB2',
                    'extra_hover'      => '#FFFFFF',
                    'extra_link2'      => '#80d572',
                    'extra_hover2'     => '#8be77c',
                    'extra_link3'      => '#ddb837',
                    'extra_hover3'     => '#eec432',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => '#transparent',
                    'input_bg_hover'   => '#transparent',
                    'input_bd_color'   => '#0E1821',
                    'input_bd_hover'   => '#0E1821',
                    'input_text'       => '#D3D5D6',
                    'input_light'      => '#B6B9BC',
                    'input_dark'       => '#FDFDFD',

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#e36650',
                    'inverse_bd_hover' => '#cb5b47',
                    'inverse_text'     => '#F9F9F9',
                    'inverse_light'    => '#6f6f6f',
                    'inverse_dark'     => '#2B2B2D',
                    'inverse_link'     => '#FDFDFD',
                    'inverse_hover'    => '#2B2B2D',

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'turquoise_light'
            'turquoise_light' => array(
                'title'    => esc_html__( 'Turquoise Light', 'stomatology' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#FFFFFF',
                    'bd_color'         => '#D0D6DD',

                    // Text and links colors
                    'text'             => '#6E7276',
                    'text_light'       => '#85898D',
                    'text_dark'        => '#2B2B2D',
                    'text_link'        => '#229FB2',
                    'text_hover'       => '#1E8FA0',
                    'text_link2'       => '#FF4F25',
                    'text_hover2'      => '#E54721',
                    'text_link3'       => '#A0B22B',
                    'text_hover3'      => '#90A026',

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#F2F7FC',
                    'alter_bg_hover'   => '#E7ECF0',
                    'alter_bd_color'   => '#D0D6DD',
                    'alter_bd_hover'   => '#C0C5CB',
                    'alter_text'       => '#6E7276',
                    'alter_light'      => '#85898D',
                    'alter_dark'       => '#2B2B2D',
                    'alter_link'       => '#229FB2',
                    'alter_hover'      => '#1E8FA0',
                    'alter_link2'      => '#FF4F25',
                    'alter_hover2'     => '#E54721',
                    'alter_link3'      => '#A0B22B',
                    'alter_hover3'     => '#90A026',

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#05090D',
                    'extra_bg_hover'   => '#0E1821',
                    'extra_bd_color'   => '#272F37',
                    'extra_bd_hover'   => '#323A43',
                    'extra_text'       => '#D3D5D6',
                    'extra_light'      => '#B6B9BC',
                    'extra_dark'       => '#FEFEFE',
                    'extra_link'       => '#229FB2',
                    'extra_hover'      => '#FFFFFF',
                    'extra_link2'      => '#80d572',
                    'extra_hover2'     => '#8be77c',
                    'extra_link3'      => '#ddb837',
                    'extra_hover3'     => '#eec432',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent',
                    'input_bg_hover'   => 'transparent',
                    'input_bd_color'   => '#D0D6DD',
                    'input_bd_hover'   => '#C0C5CB',
                    'input_text'       => '#6E7276',
                    'input_light'      => '#85898D',
                    'input_dark'       => '#2B2B2D',

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#1d1d1d',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#2B2B2D',
                    'inverse_link'     => '#FFFFFF',
                    'inverse_hover'    => '#FFFFFF',

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'aqua_default'
            'aqua_default' => array(
                'title'    => esc_html__( 'Aqua Default', 'stomatology' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#D4F0F5',
                    'bd_color'         => '#ACC0C4',

                    // Text and links colors
                    'text'             => '#3F4849',
                    'text_light'       => '#546062',
                    'text_dark'        => '#151818',
                    'text_link'        => '#36A6BF',
                    'text_hover'       => '#3095AB',
                    'text_link2'       => '#EE5253',
                    'text_hover2'      => '#D6494A',
                    'text_link3'       => '#FFC312',
                    'text_hover3'      => '#E5AF10',

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#FFFFFF',
                    'alter_bg_hover'   => '#BDE3EA',
                    'alter_bd_color'   => '#ACC0C4',
                    'alter_bd_hover'   => '#96A8AB',
                    'alter_text'       => '#3F4849',
                    'alter_light'      => '#546062',
                    'alter_dark'       => '#151818',
                    'alter_link'       => '#36A6BF',
                    'alter_hover'      => '#3095AB',
                    'alter_link2'      => '#EE5253',
                    'alter_hover2'     => '#D6494A',
                    'alter_link3'      => '#FFC312',
                    'alter_hover3'     => '#E5AF10',

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#020506',
                    'extra_bg_hover'   => '#21333B',
                    'extra_bd_color'   => '#262F37',
                    'extra_bd_hover'   => '#3E464D',
                    'extra_text'       => '#CED1D2',
                    'extra_light'      => '#9FA4A6',
                    'extra_dark'       => '#FDFDFD',
                    'extra_link'       => '#36A6BF',
                    'extra_hover'      => '#FFFFFF',
                    'extra_link2'      => '#80d572',
                    'extra_hover2'     => '#8be77c',
                    'extra_link3'      => '#ddb837',
                    'extra_hover3'     => '#eec432',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent',
                    'input_bg_hover'   => 'transparent',
                    'input_bd_color'   => '#ACC0C4',
                    'input_bd_hover'   => '#96A8AB',
                    'input_text'       => '#3F4849',
                    'input_light'      => '#546062',
                    'input_dark'       => '#151818',

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#1d1d1d',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#151818',
                    'inverse_link'     => '#FFFFFF',
                    'inverse_hover'    => '#FFFFFF',

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'aqua_dark'
            'aqua_dark'    => array(
                'title'    => esc_html__( 'Aqua Dark', 'stomatology' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#0B0F2F',
                    'bd_color'         => '#262F37',

                    // Text and links colors
                    'text'             => '#CED1D2',
                    'text_light'       => '#9FA4A6',
                    'text_dark'        => '#FFFFFF',
                    'text_link'        => '#36A6BF',
                    'text_hover'       => '#3095AB',
                    'text_link2'       => '#EE5253',
                    'text_hover2'      => '#D6494A',
                    'text_link3'       => '#FFC312',
                    'text_hover3'      => '#E5AF10',

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#12202A',
                    'alter_bg_hover'   => '#21333B',
                    'alter_bd_color'   => '#262F37',
                    'alter_bd_hover'   => '#3E464D',
                    'alter_text'       => '#CED1D2',
                    'alter_light'      => '#9FA4A6',
                    'alter_dark'       => '#FFFFFF',
                    'alter_link'       => '#36A6BF',
                    'alter_hover'      => '#3095AB',
                    'alter_link2'      => '#EE5253',
                    'alter_hover2'     => '#D6494A',
                    'alter_link3'      => '#FFC312',
                    'alter_hover3'     => '#E5AF10',

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#020506',
                    'extra_bg_hover'   => '#21333B',
                    'extra_bd_color'   => '#262F37',
                    'extra_bd_hover'   => '#3E464D',
                    'extra_text'       => '#CED1D2',
                    'extra_light'      => '#9FA4A6',
                    'extra_dark'       => '#FDFDFD',
                    'extra_link'       => '#36A6BF',
                    'extra_hover'      => '#FFFFFF',
                    'extra_link2'      => '#80d572',
                    'extra_hover2'     => '#8be77c',
                    'extra_link3'      => '#ddb837',
                    'extra_hover3'     => '#eec432',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => '#transparent',
                    'input_bg_hover'   => '#transparent',
                    'input_bd_color'   => '#262F37',
                    'input_bd_hover'   => '#262F37',
                    'input_text'       => '#CED1D2',
                    'input_light'      => '#9FA4A6',
                    'input_dark'       => '#FFFFFF',

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#e36650',
                    'inverse_bd_hover' => '#cb5b47',
                    'inverse_text'     => '#F9F9F9',
                    'inverse_light'    => '#6f6f6f',
                    'inverse_dark'     => '#151818',
                    'inverse_link'     => '#FFFFFF',
                    'inverse_hover'    => '#151818',

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'aqua_light'
            'aqua_light' => array(
                'title'    => esc_html__( 'Aqua Light', 'stomatology' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#FFFFFF',
                    'bd_color'         => '#ACC0C4',

                    // Text and links colors
                    'text'             => '#3F4849',
                    'text_light'       => '#546062',
                    'text_dark'        => '#151818',
                    'text_link'        => '#36A6BF',
                    'text_hover'       => '#3095AB',
                    'text_link2'       => '#EE5253',
                    'text_hover2'      => '#D6494A',
                    'text_link3'       => '#FFC312',
                    'text_hover3'      => '#E5AF10',

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#D4F0F5',
                    'alter_bg_hover'   => '#BDE3EA',
                    'alter_bd_color'   => '#ACC0C4',
                    'alter_bd_hover'   => '#96A8AB',
                    'alter_text'       => '#3F4849',
                    'alter_light'      => '#546062',
                    'alter_dark'       => '#151818',
                    'alter_link'       => '#36A6BF',
                    'alter_hover'      => '#3095AB',
                    'alter_link2'      => '#EE5253',
                    'alter_hover2'     => '#D6494A',
                    'alter_link3'      => '#FFC312',
                    'alter_hover3'     => '#E5AF10',

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#020506',
                    'extra_bg_hover'   => '#21333B',
                    'extra_bd_color'   => '#262F37',
                    'extra_bd_hover'   => '#3E464D',
                    'extra_text'       => '#CED1D2',
                    'extra_light'      => '#9FA4A6',
                    'extra_dark'       => '#FDFDFD',
                    'extra_link'       => '#36A6BF',
                    'extra_hover'      => '#FFFFFF',
                    'extra_link2'      => '#80d572',
                    'extra_hover2'     => '#8be77c',
                    'extra_link3'      => '#ddb837',
                    'extra_hover3'     => '#eec432',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent',
                    'input_bg_hover'   => 'transparent',
                    'input_bd_color'   => '#ACC0C4',
                    'input_bd_hover'   => '#96A8AB',
                    'input_text'       => '#3F4849',
                    'input_light'      => '#546062',
                    'input_dark'       => '#151818',

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#1d1d1d',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#151818',
                    'inverse_link'     => '#FFFFFF',
                    'inverse_hover'    => '#FFFFFF',

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),
        );
        stomatology_storage_set( 'schemes', $schemes );
        stomatology_storage_set( 'schemes_original', $schemes );

        // Add names of additional colors
        //---> For example:
        //---> stomatology_storage_set_array( 'scheme_color_names', 'new_color1', array(
        //--->     'title'       => __( 'New color 1', 'stomatology' ),
        //--->     'description' => __( 'Description of the new color 1', 'stomatology' ),
        //---> ) );


        // Additional colors for each scheme
        // Parameters:    'color' - name of the color from the scheme that should be used as source for the transformation
        //                'alpha' - to make color transparent (0.0 - 1.0)
        //                'hue', 'saturation', 'brightness' - inc/dec value for each color's component
        stomatology_storage_set(
            'scheme_colors_add', array(
                'bg_color_0'        => array(
                    'color' => 'bg_color',
                    'alpha' => 0,
                ),
                'bg_color_02'       => array(
                    'color' => 'bg_color',
                    'alpha' => 0.2,
                ),
                'bg_color_07'       => array(
                    'color' => 'bg_color',
                    'alpha' => 0.7,
                ),
                'bg_color_08'       => array(
                    'color' => 'bg_color',
                    'alpha' => 0.8,
                ),
                'bg_color_09'       => array(
                    'color' => 'bg_color',
                    'alpha' => 0.9,
                ),
                'alter_bg_color_07' => array(
                    'color' => 'alter_bg_color',
                    'alpha' => 0.7,
                ),
                'alter_bg_color_08' => array(
                    'color' => 'alter_bg_color',
                    'alpha' => 0.8,
                ),
                'alter_bg_color_04' => array(
                    'color' => 'alter_bg_color',
                    'alpha' => 0.4,
                ),
                'alter_bg_color_00' => array(
                    'color' => 'alter_bg_color',
                    'alpha' => 0,
                ),
                'alter_bg_color_02' => array(
                    'color' => 'alter_bg_color',
                    'alpha' => 0.2,
                ),
                'alter_bd_color_02' => array(
                    'color' => 'alter_bd_color',
                    'alpha' => 0.2,
                ),
                'alter_dark_015'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.15,
                ),
                'alter_dark_02'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.2,
                ),
                'alter_dark_05'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.5,
                ),
                'alter_dark_08'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.8,
                ),
                'alter_link_02'     => array(
                    'color' => 'alter_link',
                    'alpha' => 0.2,
                ),
                'alter_link_07'     => array(
                    'color' => 'alter_link',
                    'alpha' => 0.7,
                ),
                'extra_bg_color_05' => array(
                    'color' => 'extra_bg_color',
                    'alpha' => 0.5,
                ),
                'extra_bg_color_07' => array(
                    'color' => 'extra_bg_color',
                    'alpha' => 0.7,
                ),
                'extra_link_02'     => array(
                    'color' => 'extra_link',
                    'alpha' => 0.2,
                ),
                'extra_link_07'     => array(
                    'color' => 'extra_link',
                    'alpha' => 0.7,
                ),
                'text_dark_003'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.03,
                ),
                'text_dark_005'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.05,
                ),
                'text_dark_008'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.08,
                ),
                'text_dark_015'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.15,
                ),
                'text_dark_02'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.2,
                ),
                'text_dark_03'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.3,
                ),
                'text_dark_05'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.5,
                ),
                'text_dark_07'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.7,
                ),
                'text_dark_08'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.8,
                ),
                'text_link_007'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.07,
                ),
                'text_link_02'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.2,
                ),
                'text_link_03'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.3,
                ),
                'text_link_04'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.4,
                ),
                'text_link_07'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.7,
                ),
                'text_link2_08'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.8,
                ),
                'text_link2_007'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.07,
                ),
                'text_link2_02'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.2,
                ),
                'text_link2_085'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.85,
                ),
                'text_link2_000'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0,
                ),
                'text_link2_03'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.3,
                ),
                'text_link2_05'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.5,
                ),
                'text_link3_007'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.07,
                ),
                'text_link3_02'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.2,
                ),
                'text_link3_03'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.3,
                ),
                'inverse_text_03'      => array(
                    'color' => 'inverse_text',
                    'alpha' => 0.3,
                ),
                'inverse_link_08'      => array(
                    'color' => 'inverse_link',
                    'alpha' => 0.8,
                ),
                'inverse_hover_08'      => array(
                    'color' => 'inverse_hover',
                    'alpha' => 0.8,
                ),
                'text_dark_blend'   => array(
                    'color'      => 'text_dark',
                    'hue'        => 2,
                    'saturation' => -5,
                    'brightness' => 5,
                ),
                'text_link_blend'   => array(
                    'color'      => 'text_link',
                    'hue'        => 2,
                    'saturation' => -5,
                    'brightness' => 5,
                ),
                'alter_link_blend'  => array(
                    'color'      => 'alter_link',
                    'hue'        => 2,
                    'saturation' => -5,
                    'brightness' => 5,
                ),
            )
        );

        // Simple scheme editor: lists the colors to edit in the "Simple" mode.
        // For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
        // when 'main' color is changed
        // Leave 'slave' arrays empty if your scheme does not have a color dependency
        stomatology_storage_set(
            'schemes_simple', array(
                'text_link'        => array(),
                'text_hover'       => array(),
                'text_link2'       => array(),
                'text_hover2'      => array(),
                'text_link3'       => array(),
                'text_hover3'      => array(),
                'alter_link'       => array(),
                'alter_hover'      => array(),
                'alter_link2'      => array(),
                'alter_hover2'     => array(),
                'alter_link3'      => array(),
                'alter_hover3'     => array(),
                'extra_link'       => array(),
                'extra_hover'      => array(),
                'extra_link2'      => array(),
                'extra_hover2'     => array(),
                'extra_link3'      => array(),
                'extra_hover3'     => array(),
            )
        );

        // Parameters to set order of schemes in the css
        stomatology_storage_set(
            'schemes_sorted', array(
                'color_scheme',
                'header_scheme',
                'menu_scheme',
                'sidebar_scheme',
                'footer_scheme',
            )
        );

        // Color presets
        stomatology_storage_set(
            'color_presets', array(
                'autumn' => array(
                                'title'  => esc_html__( 'Autumn', 'stomatology' ),
                                'colors' => array(
                                                'default' => array(
                                                                    'text_link'  => '#d83938',
                                                                    'text_hover' => '#f2b232',
                                                                    ),
                                                'dark' => array(
                                                                    'text_link'  => '#d83938',
                                                                    'text_hover' => '#f2b232',
                                                                    )
                                                )
                            ),
                'green' => array(
                                'title'  => esc_html__( 'Natural Green', 'stomatology' ),
                                'colors' => array(
                                                'default' => array(
                                                                    'text_link'  => '#75ac78',
                                                                    'text_hover' => '#378e6d',
                                                                    ),
                                                'dark' => array(
                                                                    'text_link'  => '#75ac78',
                                                                    'text_hover' => '#378e6d',
                                                                    )
                                                )
                            ),
            )
        );
    }
}


//Activation methods
if ( ! function_exists( 'stomatology_skin_filter_activation_methods2' ) ) {
    add_filter( 'trx_addons_filter_activation_methods', 'stomatology_skin_filter_activation_methods2', 11, 1 );
    function stomatology_skin_filter_activation_methods2( $args ) {
        $args['elements_key'] = true;
        return $args;
    }
}


//Enqueue skin-specific scripts
if ( ! function_exists( 'stomatology_skin_upgrade_style' ) ) {
    add_action( 'wp_enqueue_scripts', 'stomatology_skin_upgrade_style', 2060 );
    function stomatology_skin_upgrade_style() {
        $stomatology_url = stomatology_get_file_url( stomatology_skins_get_current_skin_dir() . 'skin-upgrade-style.css' );    
        if ( '' != $stomatology_url ) {
            wp_enqueue_style( 'stomatology-skin-upgrade-style' . esc_attr( stomatology_skins_get_current_skin_name() ), $stomatology_url, array(), null );
        }
    }
}