<?php
/**
 * The template to display single post
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */

// Full post loading
$full_post_loading          = stomatology_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = stomatology_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = stomatology_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$stomatology_related_position   = stomatology_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$stomatology_posts_navigation   = stomatology_get_theme_option( 'posts_navigation' );
$stomatology_prev_post          = false;
$stomatology_prev_post_same_cat = (int)stomatology_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( stomatology_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	stomatology_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'stomatology_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $stomatology_posts_navigation ) {
		$stomatology_prev_post = get_previous_post( $stomatology_prev_post_same_cat );  // Get post from same category
		if ( ! $stomatology_prev_post && $stomatology_prev_post_same_cat ) {
			$stomatology_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $stomatology_prev_post ) {
			$stomatology_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $stomatology_prev_post ) ) {
		stomatology_sc_layouts_showed( 'featured', false );
		stomatology_sc_layouts_showed( 'title', false );
		stomatology_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $stomatology_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/content', 'single-' . stomatology_get_theme_option( 'single_style' ) ), 'single-' . stomatology_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $stomatology_related_position, 'inside' ) === 0 ) {
		$stomatology_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'stomatology_action_related_posts' );
		$stomatology_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $stomatology_related_content ) ) {
			$stomatology_related_position_inside = max( 0, min( 9, stomatology_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $stomatology_related_position_inside ) {
				$stomatology_related_position_inside = mt_rand( 1, 9 );
			}

			$stomatology_p_number         = 0;
			$stomatology_related_inserted = false;
			$stomatology_in_block         = false;
			$stomatology_content_start    = strpos( $stomatology_content, '<div class="post_content' );
			$stomatology_content_end      = strrpos( $stomatology_content, '</div>' );

			for ( $i = max( 0, $stomatology_content_start ); $i < min( strlen( $stomatology_content ) - 3, $stomatology_content_end ); $i++ ) {
				if ( $stomatology_content[ $i ] != '<' ) {
					continue;
				}
				if ( $stomatology_in_block ) {
					if ( strtolower( substr( $stomatology_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$stomatology_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $stomatology_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $stomatology_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$stomatology_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $stomatology_content[ $i + 1 ] && in_array( $stomatology_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$stomatology_p_number++;
					if ( $stomatology_related_position_inside == $stomatology_p_number ) {
						$stomatology_related_inserted = true;
						$stomatology_content = ( $i > 0 ? substr( $stomatology_content, 0, $i ) : '' )
											. $stomatology_related_content
											. substr( $stomatology_content, $i );
					}
				}
			}
			if ( ! $stomatology_related_inserted ) {
				if ( $stomatology_content_end > 0 ) {
					$stomatology_content = substr( $stomatology_content, 0, $stomatology_content_end ) . $stomatology_related_content . substr( $stomatology_content, $stomatology_content_end );
				} else {
					$stomatology_content .= $stomatology_related_content;
				}
			}
		}

		stomatology_show_layout( $stomatology_content );
	}

	// Comments
	do_action( 'stomatology_action_before_comments' );
	comments_template();
	do_action( 'stomatology_action_after_comments' );

	// Related posts
	if ( 'below_content' == $stomatology_related_position
		&& ( 'scroll' != $stomatology_posts_navigation || (int)stomatology_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)stomatology_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'stomatology_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $stomatology_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $stomatology_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $stomatology_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $stomatology_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'stomatology_action_nav_links_single_scroll_data', $stomatology_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
