<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */

if ( stomatology_sidebar_present() ) {
	
	$stomatology_sidebar_type = stomatology_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $stomatology_sidebar_type && ! stomatology_is_layouts_available() ) {
		$stomatology_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $stomatology_sidebar_type ) {
		// Default sidebar with widgets
		$stomatology_sidebar_name = stomatology_get_theme_option( 'sidebar_widgets' );
		stomatology_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $stomatology_sidebar_name ) ) {
			dynamic_sidebar( $stomatology_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$stomatology_sidebar_id = stomatology_get_custom_sidebar_id();
		do_action( 'stomatology_action_show_layout', $stomatology_sidebar_id );
	}
	$stomatology_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $stomatology_out ) ) {
		$stomatology_sidebar_position    = stomatology_get_theme_option( 'sidebar_position' );
		$stomatology_sidebar_position_ss = stomatology_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $stomatology_sidebar_position );
			echo ' sidebar_' . esc_attr( $stomatology_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $stomatology_sidebar_type );

			$stomatology_sidebar_scheme = apply_filters( 'stomatology_filter_sidebar_scheme', stomatology_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $stomatology_sidebar_scheme ) && ! stomatology_is_inherit( $stomatology_sidebar_scheme ) && 'custom' != $stomatology_sidebar_type ) {
				echo ' scheme_' . esc_attr( $stomatology_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="stomatology_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'stomatology_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $stomatology_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$stomatology_title = apply_filters( 'stomatology_filter_sidebar_control_title', 'float' == $stomatology_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'stomatology' ) : '' );
				$stomatology_text  = apply_filters( 'stomatology_filter_sidebar_control_text', 'above' == $stomatology_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'stomatology' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $stomatology_title ); ?>"><?php echo esc_html( $stomatology_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'stomatology_action_before_sidebar', 'sidebar' );
				stomatology_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $stomatology_out ) );
				do_action( 'stomatology_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'stomatology_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
