<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */

$stomatology_template = apply_filters( 'stomatology_filter_get_template_part', stomatology_blog_archive_get_template() );

if ( ! empty( $stomatology_template ) && 'index' != $stomatology_template ) {

	get_template_part( $stomatology_template );

} else {

	stomatology_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$stomatology_stickies   = is_home()
								|| ( in_array( stomatology_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) stomatology_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$stomatology_post_type  = stomatology_get_theme_option( 'post_type' );
		$stomatology_args       = array(
								'blog_style'     => stomatology_get_theme_option( 'blog_style' ),
								'post_type'      => $stomatology_post_type,
								'taxonomy'       => stomatology_get_post_type_taxonomy( $stomatology_post_type ),
								'parent_cat'     => stomatology_get_theme_option( 'parent_cat' ),
								'posts_per_page' => stomatology_get_theme_option( 'posts_per_page' ),
								'sticky'         => stomatology_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $stomatology_stickies )
															&& count( $stomatology_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		stomatology_blog_archive_start();

		do_action( 'stomatology_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'stomatology_action_before_page_author' );
			get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'stomatology_action_after_page_author' );
		}

		if ( stomatology_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'stomatology_action_before_page_filters' );
			stomatology_show_filters( $stomatology_args );
			do_action( 'stomatology_action_after_page_filters' );
		} else {
			do_action( 'stomatology_action_before_page_posts' );
			stomatology_show_posts( array_merge( $stomatology_args, array( 'cat' => $stomatology_args['parent_cat'] ) ) );
			do_action( 'stomatology_action_after_page_posts' );
		}

		do_action( 'stomatology_action_blog_archive_end' );

		stomatology_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
