<?php
/**
 * The template to display the attachment
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */


get_header();

while ( have_posts() ) {
	the_post();

	// Display post's content
	get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/content', 'single-' . stomatology_get_theme_option( 'single_style' ) ), 'single-' . stomatology_get_theme_option( 'single_style' ) );

	// Parent post navigation.
	$stomatology_posts_navigation = stomatology_get_theme_option( 'posts_navigation' );
	if ( 'links' == $stomatology_posts_navigation ) {
		?>
		<div class="nav-links-single<?php
			if ( ! stomatology_is_off( stomatology_get_theme_option( 'posts_navigation_fixed', 0 ) ) ) {
				echo ' nav-links-fixed fixed';
			}
		?>">
			<?php
			the_post_navigation( apply_filters( 'stomatology_filter_post_navigation_args', array(
					'prev_text' => '<span class="nav-arrow"></span>'
						. '<span class="meta-nav" aria-hidden="true">' . esc_html__( 'Published in', 'stomatology' ) . '</span> '
						. '<span class="screen-reader-text">' . esc_html__( 'Previous post:', 'stomatology' ) . '</span> '
						. '<h5 class="post-title">%title</h5>'
						. '<span class="post_date">%date</span>',
			), 'image' ) );
			?>
		</div>
		<?php
	}

	// Comments
	do_action( 'stomatology_action_before_comments' );
	comments_template();
	do_action( 'stomatology_action_after_comments' );
}

get_footer();
