<?php
/**
 * The Header: Logo and main menu
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( stomatology_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'stomatology_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'stomatology_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('stomatology_action_body_wrap_attributes'); ?>>

		<?php do_action( 'stomatology_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'stomatology_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('stomatology_action_page_wrap_attributes'); ?>>

			<?php do_action( 'stomatology_action_page_wrap_start' ); ?>

			<?php
			$stomatology_full_post_loading = ( stomatology_is_singular( 'post' ) || stomatology_is_singular( 'attachment' ) ) && stomatology_get_value_gp( 'action' ) == 'full_post_loading';
			$stomatology_prev_post_loading = ( stomatology_is_singular( 'post' ) || stomatology_is_singular( 'attachment' ) ) && stomatology_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $stomatology_full_post_loading && ! $stomatology_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="stomatology_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'stomatology_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'stomatology' ); ?></a>
				<?php if ( stomatology_sidebar_present() ) { ?>
				<a class="stomatology_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'stomatology_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'stomatology' ); ?></a>
				<?php } ?>
				<a class="stomatology_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'stomatology_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'stomatology' ); ?></a>

				<?php
				do_action( 'stomatology_action_before_header' );

				// Header
				$stomatology_header_type = stomatology_get_theme_option( 'header_type' );
				if ( 'custom' == $stomatology_header_type && ! stomatology_is_layouts_available() ) {
					$stomatology_header_type = 'default';
				}
				get_template_part( apply_filters( 'stomatology_filter_get_template_part', "templates/header-" . sanitize_file_name( $stomatology_header_type ) ) );

				// Side menu
				if ( in_array( stomatology_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'stomatology_filter_use_navi_mobile', true ) ) {
					get_template_part( apply_filters( 'stomatology_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'stomatology_action_after_header' );

			}
			?>

			<?php do_action( 'stomatology_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( stomatology_is_off( stomatology_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $stomatology_header_type ) ) {
						$stomatology_header_type = stomatology_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $stomatology_header_type && stomatology_is_layouts_available() ) {
						$stomatology_header_id = stomatology_get_custom_header_id();
						if ( $stomatology_header_id > 0 ) {
							$stomatology_header_meta = stomatology_get_custom_layout_meta( $stomatology_header_id );
							if ( ! empty( $stomatology_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$stomatology_footer_type = stomatology_get_theme_option( 'footer_type' );
					if ( 'custom' == $stomatology_footer_type && stomatology_is_layouts_available() ) {
						$stomatology_footer_id = stomatology_get_custom_footer_id();
						if ( $stomatology_footer_id ) {
							$stomatology_footer_meta = stomatology_get_custom_layout_meta( $stomatology_footer_id );
							if ( ! empty( $stomatology_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'stomatology_action_page_content_wrap_class', $stomatology_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'stomatology_filter_is_prev_post_loading', $stomatology_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( stomatology_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'stomatology_action_page_content_wrap_data', $stomatology_prev_post_loading );
			?>>
				<?php
				do_action( 'stomatology_action_page_content_wrap', $stomatology_full_post_loading || $stomatology_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'stomatology_filter_single_post_header', stomatology_is_singular( 'post' ) || stomatology_is_singular( 'attachment' ) ) ) {
					if ( $stomatology_prev_post_loading ) {
						if ( stomatology_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'stomatology_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$stomatology_path = apply_filters( 'stomatology_filter_get_template_part', 'templates/single-styles/' . stomatology_get_theme_option( 'single_style' ) );
					if ( stomatology_get_file_dir( $stomatology_path . '.php' ) != '' ) {
						get_template_part( $stomatology_path );
					}
				}

				// Widgets area above page
				$stomatology_body_style   = stomatology_get_theme_option( 'body_style' );
				$stomatology_widgets_name = stomatology_get_theme_option( 'widgets_above_page', 'hide' );
				$stomatology_show_widgets = ! stomatology_is_off( $stomatology_widgets_name ) && is_active_sidebar( $stomatology_widgets_name );
				if ( $stomatology_show_widgets ) {
					if ( 'fullscreen' != $stomatology_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					stomatology_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $stomatology_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'stomatology_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $stomatology_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'stomatology_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'stomatology_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="stomatology_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( stomatology_is_singular( 'post' ) || stomatology_is_singular( 'attachment' ) )
							&& $stomatology_prev_post_loading 
							&& stomatology_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'stomatology_action_between_posts' );
						}

						// Widgets area above content
						stomatology_create_widgets_area( 'widgets_above_content' );

						do_action( 'stomatology_action_page_content_start_text' );
