<?php
$stomatology_woocommerce_sc = stomatology_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $stomatology_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$stomatology_scheme = stomatology_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $stomatology_scheme ) && ! stomatology_is_inherit( $stomatology_scheme ) ) {
			echo ' scheme_' . esc_attr( $stomatology_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( stomatology_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( stomatology_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$stomatology_css      = '';
			$stomatology_bg_image = stomatology_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $stomatology_bg_image ) ) {
				$stomatology_css .= 'background-image: url(' . esc_url( stomatology_get_attachment_url( $stomatology_bg_image ) ) . ');';
			}
			if ( ! empty( $stomatology_css ) ) {
				echo ' style="' . esc_attr( $stomatology_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$stomatology_anchor_icon = stomatology_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$stomatology_anchor_text = stomatology_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $stomatology_anchor_icon ) || ! empty( $stomatology_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $stomatology_anchor_icon ) ? ' icon="' . esc_attr( $stomatology_anchor_icon ) . '"' : '' )
											. ( ! empty( $stomatology_anchor_text ) ? ' title="' . esc_attr( $stomatology_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( stomatology_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' stomatology-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$stomatology_css      = '';
				$stomatology_bg_mask  = stomatology_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$stomatology_bg_color_type = stomatology_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $stomatology_bg_color_type ) {
					$stomatology_bg_color = stomatology_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $stomatology_bg_color_type ) {
					$stomatology_bg_color = stomatology_get_scheme_color( 'bg_color', $stomatology_scheme );
				} else {
					$stomatology_bg_color = '';
				}
				if ( ! empty( $stomatology_bg_color ) && $stomatology_bg_mask > 0 ) {
					$stomatology_css .= 'background-color: ' . esc_attr(
						1 == $stomatology_bg_mask ? $stomatology_bg_color : stomatology_hex2rgba( $stomatology_bg_color, $stomatology_bg_mask )
					) . ';';
				}
				if ( ! empty( $stomatology_css ) ) {
					echo ' style="' . esc_attr( $stomatology_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$stomatology_caption     = stomatology_get_theme_option( 'front_page_woocommerce_caption' );
				$stomatology_description = stomatology_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $stomatology_caption ) || ! empty( $stomatology_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $stomatology_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $stomatology_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $stomatology_caption, 'stomatology_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $stomatology_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $stomatology_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $stomatology_description ), 'stomatology_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $stomatology_woocommerce_sc ) {
						$stomatology_woocommerce_sc_ids      = stomatology_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$stomatology_woocommerce_sc_per_page = count( explode( ',', $stomatology_woocommerce_sc_ids ) );
					} else {
						$stomatology_woocommerce_sc_per_page = max( 1, (int) stomatology_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$stomatology_woocommerce_sc_columns = max( 1, min( $stomatology_woocommerce_sc_per_page, (int) stomatology_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$stomatology_woocommerce_sc}"
										. ( 'products' == $stomatology_woocommerce_sc
												? ' ids="' . esc_attr( $stomatology_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $stomatology_woocommerce_sc
												? ' category="' . esc_attr( stomatology_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $stomatology_woocommerce_sc
												? ' orderby="' . esc_attr( stomatology_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( stomatology_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $stomatology_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $stomatology_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
