<div class="front_page_section front_page_section_contacts<?php
	$stomatology_scheme = stomatology_get_theme_option( 'front_page_contacts_scheme' );
	if ( ! empty( $stomatology_scheme ) && ! stomatology_is_inherit( $stomatology_scheme ) ) {
		echo ' scheme_' . esc_attr( $stomatology_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( stomatology_get_theme_option( 'front_page_contacts_paddings' ) );
	if ( stomatology_get_theme_option( 'front_page_contacts_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$stomatology_css      = '';
		$stomatology_bg_image = stomatology_get_theme_option( 'front_page_contacts_bg_image' );
		if ( ! empty( $stomatology_bg_image ) ) {
			$stomatology_css .= 'background-image: url(' . esc_url( stomatology_get_attachment_url( $stomatology_bg_image ) ) . ');';
		}
		if ( ! empty( $stomatology_css ) ) {
			echo ' style="' . esc_attr( $stomatology_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$stomatology_anchor_icon = stomatology_get_theme_option( 'front_page_contacts_anchor_icon' );
	$stomatology_anchor_text = stomatology_get_theme_option( 'front_page_contacts_anchor_text' );
if ( ( ! empty( $stomatology_anchor_icon ) || ! empty( $stomatology_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_contacts"'
									. ( ! empty( $stomatology_anchor_icon ) ? ' icon="' . esc_attr( $stomatology_anchor_icon ) . '"' : '' )
									. ( ! empty( $stomatology_anchor_text ) ? ' title="' . esc_attr( $stomatology_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_contacts_inner
	<?php
	if ( stomatology_get_theme_option( 'front_page_contacts_fullheight' ) ) {
		echo ' stomatology-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$stomatology_css      = '';
			$stomatology_bg_mask  = stomatology_get_theme_option( 'front_page_contacts_bg_mask' );
			$stomatology_bg_color_type = stomatology_get_theme_option( 'front_page_contacts_bg_color_type' );
			if ( 'custom' == $stomatology_bg_color_type ) {
				$stomatology_bg_color = stomatology_get_theme_option( 'front_page_contacts_bg_color' );
			} elseif ( 'scheme_bg_color' == $stomatology_bg_color_type ) {
				$stomatology_bg_color = stomatology_get_scheme_color( 'bg_color', $stomatology_scheme );
			} else {
				$stomatology_bg_color = '';
			}
			if ( ! empty( $stomatology_bg_color ) && $stomatology_bg_mask > 0 ) {
				$stomatology_css .= 'background-color: ' . esc_attr(
					1 == $stomatology_bg_mask ? $stomatology_bg_color : stomatology_hex2rgba( $stomatology_bg_color, $stomatology_bg_mask )
				) . ';';
			}
			if ( ! empty( $stomatology_css ) ) {
				echo ' style="' . esc_attr( $stomatology_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_contacts_content_wrap content_wrap">
			<?php

			// Title and description
			$stomatology_caption     = stomatology_get_theme_option( 'front_page_contacts_caption' );
			$stomatology_description = stomatology_get_theme_option( 'front_page_contacts_description' );
			if ( ! empty( $stomatology_caption ) || ! empty( $stomatology_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $stomatology_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_contacts_caption front_page_block_<?php echo ! empty( $stomatology_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $stomatology_caption, 'stomatology_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description
				if ( ! empty( $stomatology_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_contacts_description front_page_block_<?php echo ! empty( $stomatology_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $stomatology_description ), 'stomatology_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$stomatology_content = stomatology_get_theme_option( 'front_page_contacts_content' );
			$stomatology_layout  = stomatology_get_theme_option( 'front_page_contacts_layout' );
			if ( 'columns' == $stomatology_layout && ( ! empty( $stomatology_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_columns front_page_section_contacts_columns columns_wrap">
					<div class="column-1_3">
				<?php
			}

			if ( ( ! empty( $stomatology_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_content front_page_section_contacts_content front_page_block_<?php echo ! empty( $stomatology_content ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $stomatology_content, 'stomatology_kses_content' );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $stomatology_layout && ( ! empty( $stomatology_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div><div class="column-2_3">
				<?php
			}

			// Shortcode output
			$stomatology_sc = stomatology_get_theme_option( 'front_page_contacts_shortcode' );
			if ( ! empty( $stomatology_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_contacts_output front_page_block_<?php echo ! empty( $stomatology_sc ) ? 'filled' : 'empty'; ?>">
					<?php
					stomatology_show_layout( do_shortcode( $stomatology_sc ) );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $stomatology_layout && ( ! empty( $stomatology_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>

		</div>
	</div>
</div>
