<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package STOMATOLOGY
 * @since STOMATOLOGY 1.0
 */

							do_action( 'stomatology_action_page_content_end_text' );
							
							// Widgets area below the content
							stomatology_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'stomatology_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'stomatology_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'stomatology_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'stomatology_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$stomatology_body_style = stomatology_get_theme_option( 'body_style' );
					$stomatology_widgets_name = stomatology_get_theme_option( 'widgets_below_page', 'hide' );
					$stomatology_show_widgets = ! stomatology_is_off( $stomatology_widgets_name ) && is_active_sidebar( $stomatology_widgets_name );
					$stomatology_show_related = stomatology_is_single() && stomatology_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $stomatology_show_widgets || $stomatology_show_related ) {
						if ( 'fullscreen' != $stomatology_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $stomatology_show_related ) {
							do_action( 'stomatology_action_related_posts' );
						}

						// Widgets area below page content
						if ( $stomatology_show_widgets ) {
							stomatology_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $stomatology_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'stomatology_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'stomatology_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! stomatology_is_singular( 'post' ) && ! stomatology_is_singular( 'attachment' ) ) || ! in_array ( stomatology_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="stomatology_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'stomatology_action_before_footer' );

				// Footer
				$stomatology_footer_type = stomatology_get_theme_option( 'footer_type' );
				if ( 'custom' == $stomatology_footer_type && ! stomatology_is_layouts_available() ) {
					$stomatology_footer_type = 'default';
				}
				get_template_part( apply_filters( 'stomatology_filter_get_template_part', "templates/footer-" . sanitize_file_name( $stomatology_footer_type ) ) );

				do_action( 'stomatology_action_after_footer' );

			}
			?>

			<?php do_action( 'stomatology_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'stomatology_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'stomatology_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>